package org.qas.qtest.api.services.user;

import org.qas.api.AuthServiceException;
import org.qas.qtest.api.internal.QTestService;
import org.qas.qtest.api.services.user.model.*;

import java.util.List;

/**
 * UserService
 *
 * @author Dzung Nguyen
 * @version $Id UserService 2014-07-09 10:14:30z dungvnguyen $
 * @since 1.0
 */
public interface UserService extends QTestService {
  /**
   * Creates user from the given {@link CreateUserRequest create user request} instance.
   *
   * @param createUserRequest the given create user request instance.
   * @return the user information.
   * @throws AuthServiceException if an error occurs during creating user.
   */
  User create(CreateUserRequest createUserRequest) throws AuthServiceException;

  /**
   * Assign user to project from the request.
   *
   * @param assignToProjectRequest the given assign to project request.
   * @return the assign to project result.
   * @throws AuthServiceException if an error occurs during assigning user to project.
   */
  AssignToProjectResult assignToProject(AssignToProjectRequest assignToProjectRequest) throws AuthServiceException;

  /**
   * Get user of client or in a project
   *
   * @param listUserRequest request to get users
   * @return a list of {@link User}
   * @throws AuthServiceException
   */
  List<User> listUser(ListUserRequest listUserRequest) throws AuthServiceException;
}
