package org.qas.qtest.api.services.user.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.qas.qtest.api.internal.model.QTestBaseModel;

/**
 * Assignee
 *
 * @author Dzung Nguyen
 * @version $Id Assignee 2014-07-09 14:17:30z dungvnguyen $
 * @since 1.0
 */
public class Assignee extends QTestBaseModel<Assignee> {

  @JsonProperty("id")
  private Long id;

  @JsonProperty("user_name")
  private String username;

  @JsonProperty("first_name")
  private String firstName;

  @JsonProperty("last_name")
  private String lastName;

  public Assignee() {
  }

  /**
   * @return the assignee identifier.
   */
  public Long getId() {
    return id;
  }

  /**
   * Sets the assignee identifier.
   *
   * @param id the given assignee identifier.
   */
  public Assignee setId(Long id) {
    this.id = id;
    return this;
  }

  /**
   * Sets the assignee identifier and return itself.
   *
   * @param id the given assignee identifier value to set.
   * @return the assignee instance.
   */
  public Assignee withId(Long id) {
    setId(id);
    return this;
  }

  /**
   * @return the assignee name.
   */
  public String getUsername() {
    return username;
  }

  /**
   * Sets the assignee name.
   *
   * @param username the given assignee name to set.
   */
  public Assignee setUsername(String username) {
    this.username = username;
    return this;
  }

  /**
   * Sets the assignee name and return current instance.
   *
   * @param username the given assignee name to set.
   * @return the current assignee instance.
   */
  public Assignee withUsername(String username) {
    setUsername(username);
    return this;
  }

  /**
   * @return the assignee first name.
   */
  public String getFirstName() {
    return firstName;
  }

  /**
   * Sets the assignee first name.
   *
   * @param firstName the given assignee first name to set.
   */
  public Assignee setFirstName(String firstName) {
    this.firstName = firstName;
    return this;
  }

  /**
   * Sets the assignee first name.
   *
   * @param firstName the given assignee first name to set.
   * @return the current assignee instance.
   */
  public Assignee withFirstName(String firstName) {
    setFirstName(firstName);
    return this;
  }

  /**
   * @return the assignee last name.
   */
  public String getLastName() {
    return lastName;
  }

  /**
   * Sets the assignee last name.
   *
   * @param lastName the given assignee last name.
   */
  public Assignee setLastName(String lastName) {
    this.lastName = lastName;
    return this;
  }

  /**
   * Sets the assignee last name.
   *
   * @param lastName the given assignee last name to set.
   * @return the current assignee instance.
   */
  public Assignee withLastName(String lastName) {
    setLastName(lastName);
    return this;
  }

  @Override
  public Assignee clone() {
    Assignee that = new Assignee();
    that.setPropertiesFrom(this);
    return that;
  }

  @Override
  public String elementName() {
    return "assignee";
  }
}
