package org.qas.qtest.api.services.user.model;

import org.qas.api.ApiServiceRequest;

/**
 * CreateUserRequest
 *
 * @author Dzung Nguyen
 * @version $Id CreateUserRequest 2014-07-10 13:48:30z dungvnguyen $
 * @since 1.0
 */
public class CreateUserRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private User user;

  //~ class members ===========================================================
  /**
   * @return the user information.
   */
  public User getUser() {
    return user;
  }

  /**
   * Sets the user information to this request.
   *
   * @param user the given user information to set.
   */
  public void setUser(User user) {
    this.user = user;
  }

  /**
   * Sets the user information to this request.
   *
   * @param user the given user information to set.
   * @return the current instance.
   */
  public CreateUserRequest withUser(User user) {
    setUser(user);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("CreateUserRequest{\n");
    sb.append("\tuser:\n").append(user).append("\n");
    sb.append('}');
    return sb.toString();
  }
}
