package org.qas.qtest.api.services.user.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.user.model.AssignToProjectResult;

/**
 * AssignProjectResultJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id AssignProjectResultJsonUnmarshaller 2014-07-10 21:31:30z dungvnguyen $
 * @since 1.0
 */
public class AssignToProjectResultJsonUnmarshaller extends AbstractUnmarshaller<AssignToProjectResult, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static AssignToProjectResultJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static AssignToProjectResultJsonUnmarshaller getInstance() {
    if (instance == null) {
      instance = new AssignToProjectResultJsonUnmarshaller();
    }

    return instance;
  }

  @Override
  public AssignToProjectResult parse(String data) throws Exception {
    return JsonMapper.fromJson(data, AssignToProjectResult.class);
  }
}
