package org.qas.qtest.api.services.user.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.user.model.CreateUserRequest;

/**
 * CreateUserRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id CreateUserRequestMarshaller 2014-07-10 14:08:30z dungvnguyen $
 * @since 1.0
 */
public class CreateUserRequestMarshaller extends AbstractMarshaller<Request, CreateUserRequest> {
  @Override
  protected void validateRequest(CreateUserRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid request passed to call(...)");
    }

    if (in.getUser() == null) {
      throw new AuthClientException("Invalid user passed to call(...)");
    }
  }

  @Override
  protected void build(Request request, CreateUserRequest in) {
    request.setHttpMethod(HttpMethod.POST);
  }

  @Override
  protected String getServiceName() {
    return "UserService";
  }

  @Override
  protected String getActionName() {
    return "CreateUser";
  }

  @Override
  protected String getContent(CreateUserRequest in) throws Exception {
    return JsonMapper.toJson(in.getUser());
  }

  @Override
  protected StringBuilder getResourcePath(CreateUserRequest in, StringBuilder rpBuilder) {
    return rpBuilder.append("/api/v3/users");
  }
}
