/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api;

import org.qas.api.JsonMapper;
import org.qas.api.http.Protocol;
import org.qas.api.internal.PropertyContainer;
import org.qas.api.internal.util.Versions;

public class ClientConfiguration
extends PropertyContainer
implements Cloneable {
    public static final int DEFAULT_SOCKET_TIMEOUT = 50000;
    public static final int DEFAULT_MAX_CONNECTIONS = 50;
    public static final String DEFAULT_USER_AGENT = Versions.getUserAgent();
    public static final int DEFAULT_MAX_RETRIES = 3;

    public ClientConfiguration() {
        this.setProperty("user-agent", DEFAULT_USER_AGENT);
        this.setProperty("max-error-retry", 3);
        this.setProperty("protocol", (Object)Protocol.HTTPS);
        this.setProperty("max-connections", 50);
        this.setProperty("socket-timeout", 50000);
        this.setProperty("connection-timeout", 50000);
        this.setProperty("socket-buffer-size-hints", new int[]{0, 0});
        this.setProperty("proxy-port", -1);
    }

    public ClientConfiguration(ClientConfiguration other) {
        this.setPropertiesFrom(other);
    }

    public Protocol getProtocol() {
        return (Protocol)((Object)this.getProperty("protocol"));
    }

    public void setProtocol(Protocol protocol) {
        this.setProperty("protocol", (Object)protocol);
    }

    public ClientConfiguration withProtocol(Protocol protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public int getMaxConnections() {
        return ((Number)this.getProperty("max-connections")).intValue();
    }

    public void setMaxConnections(int maxConnections) {
        this.setProperty("max-connections", maxConnections);
    }

    public ClientConfiguration withMaxConnections(int maxConnections) {
        this.setMaxConnections(maxConnections);
        return this;
    }

    public String getUserAgent() {
        return (String)this.getProperty("user-agent");
    }

    public void setUserAgent(String userAgent) {
        this.setProperty("user-agent", userAgent);
    }

    public ClientConfiguration withUserAgent(String userAgent) {
        this.setUserAgent(userAgent);
        return this;
    }

    public String getProxyHost() {
        return (String)this.getProperty("proxy-host");
    }

    public void setProxyHost(String proxyHost) {
        this.setProperty("proxy-host", proxyHost);
    }

    public ClientConfiguration withProxyHost(String proxyHost) {
        this.setProxyHost(proxyHost);
        return this;
    }

    public int getProxyPort() {
        Integer port = (Integer)this.getProperty("proxy-port");
        return port == null ? -1 : port;
    }

    public void setProxyPort(int proxyPort) {
        this.setProperty("proxy-port", proxyPort);
    }

    public ClientConfiguration withProxyPort(int proxyPort) {
        this.setProxyPort(proxyPort);
        return this;
    }

    public String getProxyUsername() {
        return (String)this.getProperty("proxy-uname");
    }

    public void setProxyUsername(String username) {
        this.setProperty("proxy-uname", username);
    }

    public ClientConfiguration withProxyUsername(String username) {
        this.setProxyUsername(username);
        return this;
    }

    public String getProxyPassword() {
        return (String)this.getProperty("proxy-passwd");
    }

    public void setProxyPassword(String password) {
        this.setProperty("proxy-passwd", password);
    }

    public ClientConfiguration withProxyPassword(String password) {
        this.setProxyPassword(password);
        return this;
    }

    public String getProxyDomain() {
        return (String)this.getProperty("proxy-domain");
    }

    public void setProxyDomain(String proxyDomain) {
        this.setProperty("proxy-domain", proxyDomain);
    }

    public ClientConfiguration withProxyDomain(String proxyDomain) {
        this.setProxyDomain(proxyDomain);
        return this;
    }

    public String getProxyWorkstation() {
        return (String)this.getProperty("proxy-workstation");
    }

    public void setProxyWorkstation(String proxyWorkstation) {
        this.setProperty("proxy-workstation", proxyWorkstation);
    }

    public ClientConfiguration withProxyWorkstation(String proxyWorkstation) {
        this.setProxyWorkstation(proxyWorkstation);
        return this;
    }

    public int getMaxErrorRetry() {
        return ((Number)this.getProperty("max-error-retry")).intValue();
    }

    public void setMaxErrorRetry(int maxErrorRetry) {
        this.setProperty("max-error-retry", maxErrorRetry);
    }

    public ClientConfiguration withMaxErrorRetry(int maxErrorRetry) {
        this.setMaxErrorRetry(maxErrorRetry);
        return this;
    }

    public int getSocketTimeout() {
        return ((Number)this.getProperty("socket-timeout")).intValue();
    }

    public void setSocketTimeout(int socketTimeout) {
        this.setProperty("socket-timeout", socketTimeout);
    }

    public ClientConfiguration withSocketTimeout(int socketTimeout) {
        this.setSocketTimeout(socketTimeout);
        return this;
    }

    public int getConnectionTimeout() {
        return ((Number)this.getProperty("connection-timeout")).intValue();
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.setProperty("connection-timeout", connectionTimeout);
    }

    public ClientConfiguration withConnectionTimeout(int connectionTimeout) {
        this.setConnectionTimeout(connectionTimeout);
        return this;
    }

    public int[] getSocketBufferSizeHints() {
        return (int[])this.getProperty("socket-buffer-size-hints");
    }

    public void setSocketBufferSizeHints(int socketSendBufferSizeHint, int socketReceiveBufferSizeHint) {
        this.setProperty("socket-buffer-size-hints", new int[]{socketSendBufferSizeHint, socketReceiveBufferSizeHint});
    }

    public ClientConfiguration withSocketBufferSizeHints(int socketSendBufferSizeHint, int socketReceiveBufferSizeHint) {
        this.setSocketBufferSizeHints(socketSendBufferSizeHint, socketReceiveBufferSizeHint);
        return this;
    }

    public ClientConfiguration withProperty(String name, Object value) {
        this.setProperty(name, value);
        return this;
    }

    @Override
    public ClientConfiguration clone() {
        ClientConfiguration that = new ClientConfiguration();
        that.setPropertiesFrom(this);
        return that;
    }

    @Override
    public String toString() {
        return JsonMapper.toJson(this);
    }
}

