/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.internal.util;

import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.qas.api.internal.util.google.base.Strings;

public final class Versions {
    private static final Logger LOG = Logger.getLogger(Versions.class.getName());
    private static final String VERSION_FILE = "org/qas/api/version.properties";
    private static String version = null;
    private static String platform = null;
    private static String userAgent = null;

    private Versions() {
        throw new AssertionError((Object)"Versions utilities class must not be instantiate!");
    }

    public static String getPlatform() {
        if (Strings.isNullOrEmpty(platform)) {
            Versions.initializeVersion();
        }
        return platform;
    }

    public static String getVersion() {
        if (Strings.isNullOrEmpty(platform)) {
            Versions.initializeVersion();
        }
        return version;
    }

    public static String getUserAgent() {
        if (Strings.isNullOrEmpty(userAgent)) {
            Versions.initializeUserAgent();
        }
        return userAgent;
    }

    private static void initializeVersion() {
        InputStream stream = Versions.class.getClassLoader().getResourceAsStream(VERSION_FILE);
        Properties versionProperties = new Properties();
        try {
            if (stream == null) {
                throw new Exception("org/qas/api/version.properties not found on classpath");
            }
            versionProperties.load(stream);
            version = versionProperties.getProperty("version", "unknown");
            platform = versionProperties.getProperty("platform", "java");
        }
        catch (Exception ex) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.info("Unable to load version information with message: " + ex.getMessage());
            }
            version = "unknown";
            platform = "java";
        }
    }

    private static void initializeUserAgent() {
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append("http-auth-client-").append(Versions.getPlatform().toLowerCase()).append("/").append(Versions.getVersion()).append(" ").append(System.getProperty("os.name").replace(' ', '_')).append("/").append(System.getProperty("os.version").replace(' ', '_')).append(" ").append(System.getProperty("java.vm.name").replace(' ', '_')).append("/").append(System.getProperty("java.vm.version").replace(' ', '_'));
        String language = System.getProperty("user.language");
        String region = System.getProperty("user.region");
        if (!Strings.isNullOrEmpty(language) && !Strings.isNullOrEmpty(region)) {
            buffer.append(' ').append(language.replace(' ', '_')).append('_').append(region.replace(' ', '_'));
        }
        userAgent = buffer.toString();
    }
}

