/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.support;

import java.util.Comparator;
import java.util.Map;
import org.qas.api.internal.util.Https;
import org.qas.api.internal.util.google.base.Objects;

public final class Parameter
implements Map.Entry<String, String>,
Comparator<Parameter> {
    private final String key;
    private String value;

    public Parameter(String key) {
        this(key, null);
    }

    public Parameter(String key, String value) {
        this.key = key;
        this.value = value;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String setValue(String s) {
        try {
            String string = this.value;
            return string;
        }
        finally {
            this.value = s;
        }
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.key, this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof Parameter)) {
            return false;
        }
        Parameter that = (Parameter)obj;
        return Objects.equal(this.key, that.key) && Objects.equal(this.value, that.value);
    }

    @Override
    public int compare(Parameter p1, Parameter p2) {
        return p1.toString().compareTo(p2.toString());
    }

    public String toString() {
        return this.toStringAsHeader();
    }

    public String toStringAsQuery() {
        return Https.toQueryElement(this.key, this.value);
    }

    public String toStringAsHeader() {
        return Https.toHeaderElement(this.key, this.value);
    }
}

