/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.transform;

import java.util.logging.Logger;
import org.qas.api.AuthClientException;
import org.qas.api.AuthServiceException;
import org.qas.api.internal.util.json.JsonObject;
import org.qas.api.transform.AbstractErrorUnmarshaller;

public class JsonErrorUnmarshaller
extends AbstractErrorUnmarshaller<JsonObject> {
    private static final Logger LOG = Logger.getLogger(JsonErrorUnmarshaller.class.getName());

    public JsonErrorUnmarshaller() {
    }

    protected JsonErrorUnmarshaller(Class<? extends AuthServiceException> exceptionClass) {
        super(exceptionClass);
    }

    @Override
    public AuthServiceException unmarshall(JsonObject json) throws Exception {
        LOG.info("Unmarshall " + json);
        String message = this.parseMessage(json);
        String errorCode = this.parseErrorCode(json);
        String requestId = this.parseRequestId(json);
        String type = this.parseType(json);
        if ((null == message || message.isEmpty()) && (null == errorCode || errorCode.isEmpty())) {
            throw new AuthClientException("Neither error message nor error code is found in the error response payload.");
        }
        AuthServiceException ase = this.newException(message);
        ase.setErrorCode(errorCode);
        ase.setRequestId(requestId);
        if ("Client".equals(type)) {
            ase.setErrorType(AuthServiceException.ErrorType.Client);
        } else if ("Server".equals(type)) {
            ase.setErrorType(AuthServiceException.ErrorType.Service);
        } else {
            ase.setErrorType(AuthServiceException.ErrorType.Unknown);
        }
        return ase;
    }

    protected String parseMessage(JsonObject json) throws Exception {
        String message = "";
        if (json.has("message")) {
            message = json.getString("message");
        } else if (json.has("Message")) {
            message = json.getString("Message");
        } else if (json.has("error_description")) {
            message = json.getString("error_description");
        }
        return message;
    }

    protected String parseErrorCode(JsonObject json) throws Exception {
        if (json.has("code")) {
            return json.getString("code");
        }
        if (json.has("error")) {
            return json.getString("error");
        }
        return null;
    }

    protected String parseRequestId(JsonObject json) throws Exception {
        if (json.has("request_id")) {
            return json.getString("request_id");
        }
        return null;
    }

    protected String parseType(JsonObject json) throws Exception {
        if (json.has("type")) {
            return json.getString("type");
        }
        return null;
    }
}

