/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.http;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.qas.api.ApiServiceResponse;
import org.qas.api.ResponseMetadata;
import org.qas.api.http.HttpResponse;
import org.qas.api.http.HttpResponseHandler;
import org.qas.api.internal.util.UniqueKeys;
import org.qas.api.internal.util.google.io.ByteStreams;
import org.qas.api.transform.Unmarshaller;

public class StreamResponseHandler<T>
implements HttpResponseHandler<ApiServiceResponse<T>> {
    private static final Logger LOG = Logger.getLogger(StreamResponseHandler.class.getName());
    private Unmarshaller<T, InputStream> responseUnmarshaller;

    public StreamResponseHandler(Unmarshaller<T, InputStream> responseUnmarshaller) {
        this.responseUnmarshaller = responseUnmarshaller;
        if (responseUnmarshaller == null) {
            this.responseUnmarshaller = new Unmarshaller<T, InputStream>(){

                @Override
                public boolean isParseJson() {
                    return false;
                }

                @Override
                public T unmarshall(InputStream in) throws Exception {
                    return null;
                }

                @Override
                public T parse(String data) throws Exception {
                    return null;
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiServiceResponse<T> handle(HttpResponse<?> httpResponse) throws Exception {
        if (LOG.isLoggable(Level.ALL)) {
            LOG.log(Level.ALL, "Handle the service response.");
        }
        InputStream content = httpResponse.getContent();
        File file = File.createTempFile(UniqueKeys.generateNonce(), ".stream");
        FileOutputStream outputStream = new FileOutputStream(file);
        try {
            ApiServiceResponse<T> awsResponse = new ApiServiceResponse<T>();
            if (content != null) {
                ByteStreams.copy(content, outputStream);
                outputStream.close();
                outputStream = null;
                awsResponse.setResult(this.responseUnmarshaller.unmarshall(new FileInputStream(file)));
            } else {
                file.delete();
                awsResponse.setResult(null);
            }
            HashMap<String, String> metadata = new HashMap<String, String>();
            metadata.put("RequestId", httpResponse.getHeaders().get("x-qtest-request-id"));
            awsResponse.setMetadata(new ResponseMetadata(metadata));
            ApiServiceResponse<T> apiServiceResponse = awsResponse;
            return apiServiceResponse;
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return false;
    }
}

