/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.internal.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.qas.api.JsonMapper;
import org.qas.qtest.api.internal.model.AllowedValue;
import org.qas.qtest.api.internal.model.DataType;
import org.qas.qtest.api.internal.model.QTestBaseModel;

public class Field
extends QTestBaseModel<Field> {
    @JsonProperty(value="id")
    private Long id;
    @JsonProperty(value="label")
    private String label;
    @JsonProperty(value="original_name")
    private String originName;
    @JsonProperty(value="required")
    private Boolean required;
    @JsonProperty(value="constrained")
    private Boolean constrained;
    @JsonProperty(value="searchable")
    private Boolean searchable;
    @JsonProperty(value="free_text_search")
    private Boolean freeTextSearch;
    @JsonProperty(value="search_key")
    private String searchKey;
    @JsonProperty(value="data_type")
    private int dataTypeId;
    @JsonProperty(value="order")
    private Integer order;
    @JsonProperty(value="multiple")
    private Boolean multiple;
    @JsonProperty(value="attribute_type")
    private String attributeType;
    @JsonProperty(value="system_field")
    private Boolean systemField;
    @JsonProperty(value="allowed_values")
    List<AllowedValue> allowedValues;
    @JsonProperty(value="is_active")
    private Boolean active;
    @JsonIgnore
    private DataType dataType;

    public Field() {
        this.setMultiple(Boolean.FALSE);
        this.setRequired(Boolean.FALSE);
        this.setConstrained(Boolean.FALSE);
    }

    public Long getId() {
        return this.id;
    }

    public Field setId(Long id) {
        this.id = id;
        return this;
    }

    public Field withId(Long id) {
        this.setId(id);
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public Field setLabel(String label) {
        this.label = label;
        return this;
    }

    public Field withLabel(String label) {
        this.setLabel(label);
        return this;
    }

    public String getOriginName() {
        return this.originName;
    }

    public Field setOriginName(String originName) {
        this.originName = originName;
        return this;
    }

    public Field withOriginName(String originName) {
        this.originName = originName;
        return this;
    }

    public Boolean isRequired() {
        return this.required;
    }

    public Field setRequired(Boolean required) {
        this.required = required;
        return this;
    }

    public Field withRequired(Boolean required) {
        return this.setRequired(required);
    }

    public Boolean isConstrained() {
        return this.constrained;
    }

    public Field setConstrained(Boolean constrained) {
        this.constrained = constrained;
        return this;
    }

    public Field withConstrained(Boolean constrained) {
        this.setConstrained(constrained);
        return this;
    }

    public Boolean isSearchable() {
        return this.searchable;
    }

    public Field setSearchable(Boolean searchable) {
        this.searchable = searchable;
        return this;
    }

    public Field withSearchable(Boolean searchable) {
        this.setSearchable(searchable);
        return this;
    }

    public Boolean isFreeTextSearch() {
        return this.freeTextSearch;
    }

    public Field setFreeTextSearch(Boolean freeTextSearch) {
        this.freeTextSearch = freeTextSearch;
        return this;
    }

    public Field withFreeTextSearch(Boolean freeTextSearch) {
        this.setFreeTextSearch(freeTextSearch);
        return this;
    }

    public String getSearchKey() {
        return this.searchKey;
    }

    public Field setSearchKey(String searchKey) {
        this.searchKey = searchKey;
        return this;
    }

    public Field withSearchKey(String searchKey) {
        this.setSearchKey(searchKey);
        return this;
    }

    public int getDataTypeId() {
        if (null != this.dataType) {
            return this.dataType.getId();
        }
        return this.dataTypeId;
    }

    @JsonGetter(value="data_type_name")
    public DataType getDataType() {
        return this.dataType;
    }

    public Field setDataTypeId(int dataTypeId) {
        this.dataTypeId = dataTypeId;
        this.dataType = DataType.matches(dataTypeId);
        return this;
    }

    public Field setDataType(DataType dataType) {
        this.dataType = dataType;
        if (null != dataType) {
            this.dataTypeId = dataType.getId();
        }
        return this;
    }

    public Field withDataType(DataType dataType) {
        this.setDataType(dataType);
        return this;
    }

    public Integer getOrder() {
        return this.order;
    }

    public Field setOrder(Integer order) {
        this.order = order;
        return this;
    }

    public Field withOrder(Integer order) {
        this.setOrder(order);
        return this;
    }

    public Boolean isMultiple() {
        return this.multiple;
    }

    public Field setMultiple(Boolean multiple) {
        this.multiple = multiple;
        return this;
    }

    public Field withMultiple(Boolean multiple) {
        this.setMultiple(multiple);
        return this;
    }

    public String getAttributeType() {
        return this.attributeType;
    }

    public Field setAttributeType(String attributeType) {
        this.attributeType = attributeType;
        return this;
    }

    public Field withAttributeType(String attributeType) {
        this.setAttributeType(attributeType);
        return this;
    }

    public Boolean isSystemField() {
        return this.systemField;
    }

    public Field setSystemField(Boolean systemField) {
        this.systemField = systemField;
        return this;
    }

    public Field withSystemField(Boolean systemField) {
        this.setSystemField(systemField);
        return this;
    }

    public Boolean isActive() {
        return this.active;
    }

    public Field setActive(Boolean active) {
        this.active = active;
        return this;
    }

    public Field withActive(Boolean active) {
        this.active = active;
        return this;
    }

    public List<AllowedValue> getAllowedValues() {
        if (null == this.allowedValues) {
            return Collections.emptyList();
        }
        return this.allowedValues;
    }

    public Field setAllowedValues(List<AllowedValue> allowedValues) {
        this.allowedValues = allowedValues;
        return this;
    }

    public Field withAllowedValues(List<AllowedValue> allowedValues) {
        this.setAllowedValues(allowedValues);
        return this;
    }

    public Field addAllowedValue(AllowedValue allowedValue) {
        if (this.allowedValues == null) {
            this.allowedValues = new LinkedList<AllowedValue>();
        }
        this.allowedValues.add(allowedValue);
        return this;
    }

    @Override
    @JsonIgnore
    public Field clone() {
        Field that = new Field();
        that.setPropertiesFrom(this);
        return that;
    }

    @Override
    @JsonIgnore
    public String elementName() {
        return "field";
    }

    @Override
    public String toString() {
        return JsonMapper.toJson(this);
    }
}

