/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.attachment.model.transform;

import java.io.BufferedInputStream;
import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.attachment.model.AttachmentRequest;

public class AttachmentRequestMarshaller
extends AbstractMarshaller<Request, AttachmentRequest> {
    @Override
    protected void validateRequest(AttachmentRequest in) throws Exception {
        if (in == null) {
            throw new AuthClientException("Invalid argument passed to call(...)");
        }
        if (in.getProjectId() == null || in.getProjectId() <= 0L) {
            throw new AuthClientException("Invalid project id passed to call (...)");
        }
        if (in.getType() == null) {
            throw new AuthClientException("Invalid type passed to call(...)");
        }
        if (in.getTypeId() == null || in.getTypeId() <= 0L) {
            throw new AuthClientException("Invalid type id passed to call(...)");
        }
        if (in.getFileName() == null) {
            throw new AuthClientException("Invalid file-name passed to call(...)");
        }
        if (in.getContentType() == null) {
            throw new AuthClientException("Invalid content-type passed to call(...)");
        }
        if (in.getContent() == null) {
            throw new AuthClientException("Invalid content passed to call(...)");
        }
    }

    @Override
    protected void build(Request request, AttachmentRequest in) {
        request.setHttpMethod(HttpMethod.POST);
        request.setHeader("Content-Type", in.getContentType());
        request.setHeader("Accept", "application/json");
        request.setHeader("File-Name", in.getFileName());
        if (in.getContent().markSupported()) {
            request.setContent(in.getContent());
        } else {
            request.setContent(new BufferedInputStream(in.getContent()));
        }
    }

    @Override
    protected String getServiceName() {
        return "AttachmentService";
    }

    @Override
    protected String getActionName() {
        return "Attach";
    }

    @Override
    protected String getContent(AttachmentRequest in) throws Exception {
        return null;
    }

    @Override
    protected StringBuilder getResourcePath(AttachmentRequest in, StringBuilder rpBuilder) {
        rpBuilder.append("/api/v3/projects/");
        rpBuilder.append(in.getProjectId()).append("/").append(in.getType().getResourcePath()).append("/").append(in.getTypeId()).append("/blob-handles");
        return rpBuilder;
    }
}

