/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.authenticate;

import java.util.ArrayList;
import java.util.Map;
import org.qas.api.ApiServiceResponse;
import org.qas.api.AuthClientException;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.Credentials;
import org.qas.api.Request;
import org.qas.api.auth.NoNeedSigner;
import org.qas.api.http.ExecutionContext;
import org.qas.api.http.HttpAuthClient;
import org.qas.api.http.HttpResponseHandler;
import org.qas.api.http.JsonErrorResponseHandler;
import org.qas.api.http.JsonResponseHandler;
import org.qas.api.http.StringResponseHandler;
import org.qas.api.http.basic.HttpUrlConnectionAuthClient;
import org.qas.api.internal.util.google.base.Throwables;
import org.qas.api.internal.util.json.JsonObject;
import org.qas.api.transform.JsonErrorUnmarshaller;
import org.qas.api.transform.Unmarshaller;
import org.qas.qtest.api.internal.QTestApiWebServiceClient;
import org.qas.qtest.api.services.authenticate.AuthenticateService;
import org.qas.qtest.api.services.authenticate.model.AuthenticateRequest;
import org.qas.qtest.api.services.authenticate.model.OAuthAuthenticateRequest;
import org.qas.qtest.api.services.authenticate.model.OAuthTokenRefreshRequest;
import org.qas.qtest.api.services.authenticate.model.OAuthTokenResponse;
import org.qas.qtest.api.services.authenticate.model.OAuthTokenStatusRequest;
import org.qas.qtest.api.services.authenticate.model.OAuthTokenStatusResponse;
import org.qas.qtest.api.services.authenticate.model.ValidateTokenRequest;
import org.qas.qtest.api.services.authenticate.model.transform.AuthenticateRequestMarshaller;
import org.qas.qtest.api.services.authenticate.model.transform.OAuthAuthenticateRequestMarshaller;
import org.qas.qtest.api.services.authenticate.model.transform.OAuthTokenRefreshRequestMarshaller;
import org.qas.qtest.api.services.authenticate.model.transform.OAuthTokenResponseJsonUnmarshaller;
import org.qas.qtest.api.services.authenticate.model.transform.OAuthTokenStatusRequestMarshaller;
import org.qas.qtest.api.services.authenticate.model.transform.OAuthTokenStatusResponseJsonUnmarshaller;
import org.qas.qtest.api.services.authenticate.model.transform.ValidateTokenRequestMarshaller;
import org.qas.qtest.api.services.user.model.User;
import org.qas.qtest.api.services.user.model.transform.UserJsonUnmarshaller;

public class AuthenticateServiceClient
extends QTestApiWebServiceClient<AuthenticateServiceClient>
implements AuthenticateService {
    public AuthenticateServiceClient() {
        this(new ClientConfiguration());
    }

    public AuthenticateServiceClient(ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.init();
    }

    @Override
    protected HttpAuthClient createHttpAuthClient(ClientConfiguration configuration) {
        return new HttpUrlConnectionAuthClient(configuration);
    }

    private <X> X invoke(Request request, HttpResponseHandler<ApiServiceResponse<X>> responseHandler) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        for (Map.Entry<String, String> entry : request.getOriginalRequest().copyPrivateRequestParameters().entrySet()) {
            request.addParameter(entry.getKey(), entry.getValue());
        }
        ExecutionContext executionContext = this.createExecutionContext();
        executionContext.setSigner(new NoNeedSigner());
        executionContext.setCredentials(new Credentials(){});
        ArrayList<Unmarshaller<AuthServiceException, JsonObject>> exceptionsUnmarshallers = new ArrayList<Unmarshaller<AuthServiceException, JsonObject>>();
        exceptionsUnmarshallers.add(new JsonErrorUnmarshaller());
        JsonErrorResponseHandler errorResponseHandler = new JsonErrorResponseHandler(exceptionsUnmarshallers);
        return (X)this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @Override
    public String authenticate(AuthenticateRequest authenticateRequest) throws AuthServiceException {
        try {
            Object request = new AuthenticateRequestMarshaller().marshall(authenticateRequest);
            return this.invoke((Request)request, new StringResponseHandler());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown exception occurs during authenticate to qTest service.", ex);
        }
    }

    @Override
    public User validate(ValidateTokenRequest validateTokenRequest) throws AuthServiceException {
        try {
            Object request = new ValidateTokenRequestMarshaller().marshall(validateTokenRequest);
            return (User)this.invoke((Request)request, (HttpResponseHandler)new JsonResponseHandler<User>(UserJsonUnmarshaller.getInstance()));
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown exception occurs during validate token to qTest service.", ex);
        }
    }

    @Override
    public OAuthTokenResponse authenticate(OAuthAuthenticateRequest authenticateRequest) throws AuthServiceException {
        try {
            Object request = new OAuthAuthenticateRequestMarshaller().marshall(authenticateRequest);
            return (OAuthTokenResponse)this.invoke((Request)request, (HttpResponseHandler)new JsonResponseHandler<OAuthTokenResponse>(OAuthTokenResponseJsonUnmarshaller.getInstance()));
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown exception occurs during authenticate to qTest service via OAuth.", ex);
        }
    }

    @Override
    public OAuthTokenStatusResponse status(OAuthTokenStatusRequest statusRequest) throws AuthServiceException {
        try {
            Object request = new OAuthTokenStatusRequestMarshaller().marshall(statusRequest);
            return (OAuthTokenStatusResponse)this.invoke((Request)request, (HttpResponseHandler)new JsonResponseHandler<OAuthTokenStatusResponse>(OAuthTokenStatusResponseJsonUnmarshaller.getInstance()));
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown exception occurs during request status to qTest service via OAuth.", ex);
        }
    }

    @Override
    public OAuthTokenStatusResponse refresh(OAuthTokenRefreshRequest refreshRequest) throws AuthServiceException {
        try {
            Object request = new OAuthTokenRefreshRequestMarshaller().marshall(refreshRequest);
            return (OAuthTokenStatusResponse)this.invoke((Request)request, (HttpResponseHandler)new JsonResponseHandler<OAuthTokenStatusResponse>(OAuthTokenStatusResponseJsonUnmarshaller.getInstance()));
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown exception occurs during refresh token to qTest service via OAuth.", ex);
        }
    }
}

