/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.client;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.handler.AsyncHandler;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.services.client.ClientServiceAsync;
import org.qas.qtest.api.services.client.ClientServiceClient;
import org.qas.qtest.api.services.client.model.Client;
import org.qas.qtest.api.services.client.model.GetClientRequest;
import org.qas.qtest.api.services.client.model.SetSessionUrlRequest;

public class ClientServiceAsyncClient
extends ClientServiceClient
implements ClientServiceAsync {
    public ClientServiceAsyncClient() {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration(), Executors.newCachedThreadPool());
    }

    public ClientServiceAsyncClient(ExecutorService executorService) {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration(), executorService);
    }

    public ClientServiceAsyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public ClientServiceAsyncClient(ClientConfiguration clientConfiguration, ExecutorService executorService) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration, executorService);
    }

    public ClientServiceAsyncClient(QTestCredentials credentials) {
        this(credentials, new ClientConfiguration(), Executors.newCachedThreadPool());
    }

    public ClientServiceAsyncClient(QTestCredentials credentials, ExecutorService executorService) {
        this(credentials, new ClientConfiguration(), executorService);
    }

    public ClientServiceAsyncClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
        this(credentials, clientConfiguration, Executors.newCachedThreadPool());
    }

    public ClientServiceAsyncClient(QTestCredentials credentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        this(new StaticQTestCredentialsProvider(credentials), clientConfiguration, executorService);
    }

    public ClientServiceAsyncClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this(credentialsProvider, clientConfiguration, Executors.newCachedThreadPool());
    }

    public ClientServiceAsyncClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(credentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    @Override
    public Future<Client> getClientAsync(final GetClientRequest getClientRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<Client>(){

            @Override
            public Client call() throws Exception {
                return ClientServiceAsyncClient.this.getClient(getClientRequest);
            }
        });
    }

    @Override
    public Future<Client> getClientAsync(final GetClientRequest getClientRequest, final AsyncHandler<GetClientRequest, Client> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<Client>(){

            @Override
            public Client call() throws Exception {
                Client result;
                try {
                    result = ClientServiceAsyncClient.this.getClient(getClientRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getClientRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> setSessionUrlAsync(final SetSessionUrlRequest setSessionUrlRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ClientServiceAsyncClient.this.setSessionUrl(setSessionUrlRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> setSessionUrlAsync(final SetSessionUrlRequest setSessionUrlRequest, final AsyncHandler<SetSessionUrlRequest, Void> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    ClientServiceAsyncClient.this.setSessionUrl(setSessionUrlRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(setSessionUrlRequest, null);
                return null;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdown();
    }
}

