/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.design;

import java.util.List;
import org.qas.api.AuthClientException;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.Request;
import org.qas.api.internal.util.google.base.Throwables;
import org.qas.api.transform.VoidJsonUnmarshaller;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.internal.QTestApiWebServiceClient;
import org.qas.qtest.api.internal.model.CreateObjectCommentRequest;
import org.qas.qtest.api.internal.model.Field;
import org.qas.qtest.api.internal.model.transform.CreateObjectCommentRequestMarshaller;
import org.qas.qtest.api.internal.model.transform.ListFieldJsonUnmarshaller;
import org.qas.qtest.api.services.design.TestDesignService;
import org.qas.qtest.api.services.design.model.ApproveTestCaseRequest;
import org.qas.qtest.api.services.design.model.AutomationTestCase;
import org.qas.qtest.api.services.design.model.CreateAutomationTestCaseRequest;
import org.qas.qtest.api.services.design.model.CreateTestCaseRequest;
import org.qas.qtest.api.services.design.model.CreateTestStepRequest;
import org.qas.qtest.api.services.design.model.DeleteTestCaseRequest;
import org.qas.qtest.api.services.design.model.GetTestCaseFieldsRequest;
import org.qas.qtest.api.services.design.model.GetTestCaseRequest;
import org.qas.qtest.api.services.design.model.GetTestStepRequest;
import org.qas.qtest.api.services.design.model.ListTestCaseRequest;
import org.qas.qtest.api.services.design.model.ListTestStepRequest;
import org.qas.qtest.api.services.design.model.MoveTestCaseRequest;
import org.qas.qtest.api.services.design.model.TestCase;
import org.qas.qtest.api.services.design.model.TestStep;
import org.qas.qtest.api.services.design.model.UpdateTestCaseRequest;
import org.qas.qtest.api.services.design.model.transform.ApproveTestCaseRequestMarshaller;
import org.qas.qtest.api.services.design.model.transform.AutomationTestCaseJsonUnmarshaller;
import org.qas.qtest.api.services.design.model.transform.CreateAutomationTestCaseRequestMarshaller;
import org.qas.qtest.api.services.design.model.transform.CreateTestCaseRequestMarshaller;
import org.qas.qtest.api.services.design.model.transform.CreateTestStepRequestMarshaller;
import org.qas.qtest.api.services.design.model.transform.DeleteTestCaseRequestMarshaller;
import org.qas.qtest.api.services.design.model.transform.GetTestCaseFieldsRequestMarshaller;
import org.qas.qtest.api.services.design.model.transform.GetTestCaseRequestMarshaller;
import org.qas.qtest.api.services.design.model.transform.GetTestStepRequestMarshaller;
import org.qas.qtest.api.services.design.model.transform.ListTestCaseJsonUnmarshaller;
import org.qas.qtest.api.services.design.model.transform.ListTestCaseRequestMarshaller;
import org.qas.qtest.api.services.design.model.transform.ListTestStepJsonUnmarshaller;
import org.qas.qtest.api.services.design.model.transform.ListTestStepRequestMarshaller;
import org.qas.qtest.api.services.design.model.transform.MoveTestCaseRequestMarshaller;
import org.qas.qtest.api.services.design.model.transform.TestCaseJsonUnmarshaller;
import org.qas.qtest.api.services.design.model.transform.TestStepJsonUnmarshaller;
import org.qas.qtest.api.services.design.model.transform.UpdateTestCaseRequestMarshaller;

public class TestDesignServiceClient
extends QTestApiWebServiceClient<TestDesignServiceClient>
implements TestDesignService {
    public TestDesignServiceClient() {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration());
    }

    public TestDesignServiceClient(ClientConfiguration clientConfiguration) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration);
    }

    public TestDesignServiceClient(QTestCredentials credentials) {
        this(credentials, new ClientConfiguration());
    }

    public TestDesignServiceClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = new StaticQTestCredentialsProvider(credentials);
        this.init();
    }

    public TestDesignServiceClient(QTestCredentialsProvider credentialsProvider) {
        this(credentialsProvider, new ClientConfiguration());
    }

    public TestDesignServiceClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = credentialsProvider;
        this.init();
    }

    @Override
    public TestCase getTestCase(GetTestCaseRequest testCaseRequest) throws AuthServiceException {
        try {
            Request request = new GetTestCaseRequestMarshaller().marshall(testCaseRequest);
            return this.invoke(request, TestCaseJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute get test case request", ex);
        }
    }

    @Override
    public List<TestStep> listTestStep(ListTestStepRequest testStepRequest) throws AuthServiceException {
        try {
            Object request = new ListTestStepRequestMarshaller().marshall(testStepRequest);
            return this.invoke((Request)request, ListTestStepJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute list test step request", ex);
        }
    }

    @Override
    public TestStep getTestStep(GetTestStepRequest testStepRequest) throws AuthServiceException {
        try {
            Object request = new GetTestStepRequestMarshaller().marshall(testStepRequest);
            return this.invoke((Request)request, TestStepJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute get test step request", ex);
        }
    }

    @Override
    public TestCase createTestCase(CreateTestCaseRequest testCaseRequest) throws AuthServiceException {
        try {
            Request request = new CreateTestCaseRequestMarshaller().marshall(testCaseRequest);
            return this.invoke(request, TestCaseJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute create test case request", ex);
        }
    }

    @Override
    public TestStep createTestStep(CreateTestStepRequest testStepRequest) throws AuthServiceException {
        try {
            Object request = new CreateTestStepRequestMarshaller().marshall(testStepRequest);
            return this.invoke((Request)request, TestStepJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during executing create test step request", ex);
        }
    }

    @Override
    public List<TestCase> listTestCase(ListTestCaseRequest listTestCaseRequest) throws AuthServiceException {
        try {
            Request request = new ListTestCaseRequestMarshaller().marshall(listTestCaseRequest);
            return this.invoke(request, ListTestCaseJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during executing listing test case request", ex);
        }
    }

    @Override
    public List<Field> getTestCaseFields(GetTestCaseFieldsRequest getTestCaseFieldsRequest) throws AuthServiceException {
        try {
            Object request = new GetTestCaseFieldsRequestMarshaller().marshall(getTestCaseFieldsRequest);
            return this.invoke((Request)request, ListFieldJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during getting testcase field", ex);
        }
    }

    @Override
    public TestCase addComment(CreateObjectCommentRequest createObjectCommentRequest) throws AuthServiceException {
        try {
            Object request = new CreateObjectCommentRequestMarshaller("TestDesignService").marshall(createObjectCommentRequest);
            return this.invoke((Request)request, TestCaseJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during creating testcase comment", ex);
        }
    }

    @Override
    public AutomationTestCase createAutomationTestCase(CreateAutomationTestCaseRequest automationTestCaseRequest) throws AuthServiceException {
        try {
            Request request = new CreateAutomationTestCaseRequestMarshaller().marshall(automationTestCaseRequest);
            return this.invoke(request, AutomationTestCaseJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute create test case request", ex);
        }
    }

    @Override
    public void deleteTestCase(DeleteTestCaseRequest testCaseRequest) throws AuthServiceException {
        try {
            Request request = new DeleteTestCaseRequestMarshaller().marshall(testCaseRequest);
            this.invoke(request, new VoidJsonUnmarshaller());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute delete test case request", ex);
        }
    }

    @Override
    public TestCase updateTestCase(UpdateTestCaseRequest testCaseRequest) throws AuthServiceException {
        try {
            Request request = new UpdateTestCaseRequestMarshaller().marshall(testCaseRequest);
            return this.invoke(request, TestCaseJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute update test case request", ex);
        }
    }

    @Override
    public TestCase moveTestCase(MoveTestCaseRequest testCaseRequest) throws AuthServiceException {
        try {
            Request request = new MoveTestCaseRequestMarshaller().marshall(testCaseRequest);
            return this.invoke(request, TestCaseJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute move test case request", ex);
        }
    }

    @Override
    public TestCase approveTestCase(ApproveTestCaseRequest testCaseRequest) throws AuthServiceException {
        try {
            Request request = new ApproveTestCaseRequestMarshaller().marshall(testCaseRequest);
            return this.invoke(request, TestCaseJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during approve test case request", ex);
        }
    }
}

