/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.design.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.design.model.GetTestCaseRequest;
import org.qas.qtest.api.services.design.model.transform.AbstractTestCaseRequestMarshaller;

public final class GetTestCaseRequestMarshaller
extends AbstractTestCaseRequestMarshaller<GetTestCaseRequest> {
    @Override
    public Request marshall(GetTestCaseRequest testCaseRequest) throws Exception {
        testCaseRequest = ApiPreconditions.notNull(testCaseRequest);
        GetTestCaseRequestMarshaller.validateProjectId(testCaseRequest.getProjectId());
        GetTestCaseRequestMarshaller.validateTestCaseId(testCaseRequest.getTestCaseId());
        Request request = this.createJsonRequest(testCaseRequest, "GetTestCase", HttpMethod.GET);
        StringBuilder pathBuilder = new StringBuilder(this.createApiBasePathWithProject(testCaseRequest.getProjectId()));
        pathBuilder.append("/test-cases/").append(testCaseRequest.getTestCaseId());
        if (testCaseRequest.getTestCaseVersion() != null && testCaseRequest.getTestCaseVersion() > 0L) {
            request.addParameter("versionId", String.valueOf(testCaseRequest.getTestCaseVersion()));
        }
        if (testCaseRequest.isIncludeTeststeps()) {
            request.addParameter("expand", "teststep");
        }
        request.setResourcePath(pathBuilder.toString());
        return request;
    }
}

