/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.execution;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.handler.AsyncHandler;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.services.execution.TestExecutionServiceAsync;
import org.qas.qtest.api.services.execution.TestExecutionServiceClient;
import org.qas.qtest.api.services.execution.model.AutomationTestLogRequest;
import org.qas.qtest.api.services.execution.model.ExecutionStatus;
import org.qas.qtest.api.services.execution.model.GetLastLogRequest;
import org.qas.qtest.api.services.execution.model.GetTestRunRequest;
import org.qas.qtest.api.services.execution.model.ListExecutionStatusRequest;
import org.qas.qtest.api.services.execution.model.ListTestRunRequest;
import org.qas.qtest.api.services.execution.model.ListTestSuiteRequest;
import org.qas.qtest.api.services.execution.model.SubmitTestLogRequest;
import org.qas.qtest.api.services.execution.model.TestLog;
import org.qas.qtest.api.services.execution.model.TestRun;
import org.qas.qtest.api.services.execution.model.TestSuite;

public class TestExecutionServiceAsyncClient
extends TestExecutionServiceClient
implements TestExecutionServiceAsync {
    public TestExecutionServiceAsyncClient() {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration(), Executors.newCachedThreadPool());
    }

    public TestExecutionServiceAsyncClient(ExecutorService executorService) {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration(), executorService);
    }

    public TestExecutionServiceAsyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public TestExecutionServiceAsyncClient(ClientConfiguration clientConfiguration, ExecutorService executorService) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration, executorService);
    }

    public TestExecutionServiceAsyncClient(QTestCredentials credentials) {
        this(credentials, new ClientConfiguration(), Executors.newCachedThreadPool());
    }

    public TestExecutionServiceAsyncClient(QTestCredentials credentials, ExecutorService executorService) {
        this(credentials, new ClientConfiguration(), executorService);
    }

    public TestExecutionServiceAsyncClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
        this(credentials, clientConfiguration, Executors.newCachedThreadPool());
    }

    public TestExecutionServiceAsyncClient(QTestCredentials credentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        this(new StaticQTestCredentialsProvider(credentials), clientConfiguration, executorService);
    }

    public TestExecutionServiceAsyncClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this(credentialsProvider, clientConfiguration, Executors.newCachedThreadPool());
    }

    public TestExecutionServiceAsyncClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(credentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    @Override
    public Future<TestLog> submitAutomationTestLogAsync(final AutomationTestLogRequest automationTestLogRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<TestLog>(){

            @Override
            public TestLog call() throws Exception {
                return TestExecutionServiceAsyncClient.this.submitAutomationTestLog(automationTestLogRequest);
            }
        });
    }

    @Override
    public Future<TestLog> submitAutomationTestLogAsync(final AutomationTestLogRequest automationTestLogRequest, final AsyncHandler<AutomationTestLogRequest, TestLog> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<TestLog>(){

            @Override
            public TestLog call() throws Exception {
                TestLog result;
                try {
                    result = TestExecutionServiceAsyncClient.this.submitAutomationTestLog(automationTestLogRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(automationTestLogRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<TestLog> submitTestLogAsync(final SubmitTestLogRequest submitTestLogRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<TestLog>(){

            @Override
            public TestLog call() throws Exception {
                return TestExecutionServiceAsyncClient.this.submitTestLog(submitTestLogRequest);
            }
        });
    }

    @Override
    public Future<TestLog> submitTestLogAsync(final SubmitTestLogRequest submitTestLogRequest, final AsyncHandler<SubmitTestLogRequest, TestLog> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<TestLog>(){

            @Override
            public TestLog call() throws Exception {
                TestLog result;
                try {
                    result = TestExecutionServiceAsyncClient.this.submitTestLog(submitTestLogRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(submitTestLogRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<TestLog> getLastLogAsync(final GetLastLogRequest getLastLogRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<TestLog>(){

            @Override
            public TestLog call() throws Exception {
                return TestExecutionServiceAsyncClient.this.getLastLog(getLastLogRequest);
            }
        });
    }

    @Override
    public Future<TestLog> getLastLogAsync(final GetLastLogRequest getLastLogRequest, final AsyncHandler<GetLastLogRequest, TestLog> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<TestLog>(){

            @Override
            public TestLog call() throws Exception {
                TestLog result;
                try {
                    result = TestExecutionServiceAsyncClient.this.getLastLog(getLastLogRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getLastLogRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<List<ExecutionStatus>> listExecutionStatusAsync(final ListExecutionStatusRequest executionStatusRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<List<ExecutionStatus>>(){

            @Override
            public List<ExecutionStatus> call() throws Exception {
                return TestExecutionServiceAsyncClient.this.listExecutionStatus(executionStatusRequest);
            }
        });
    }

    @Override
    public Future<List<ExecutionStatus>> listExecutionStatusAsync(final ListExecutionStatusRequest executionStatusRequest, final AsyncHandler<ListExecutionStatusRequest, List<ExecutionStatus>> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<List<ExecutionStatus>>(){

            @Override
            public List<ExecutionStatus> call() throws Exception {
                List<ExecutionStatus> result;
                try {
                    result = TestExecutionServiceAsyncClient.this.listExecutionStatus(executionStatusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(executionStatusRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<List<TestRun>> listTestRunAsync(final ListTestRunRequest testRunRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<List<TestRun>>(){

            @Override
            public List<TestRun> call() throws Exception {
                return TestExecutionServiceAsyncClient.this.listTestRun(testRunRequest);
            }
        });
    }

    @Override
    public Future<List<TestRun>> listTestRunAsync(final ListTestRunRequest testRunRequest, final AsyncHandler<ListTestRunRequest, List<TestRun>> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<List<TestRun>>(){

            @Override
            public List<TestRun> call() throws Exception {
                List<TestRun> result;
                try {
                    result = TestExecutionServiceAsyncClient.this.listTestRun(testRunRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(testRunRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<TestRun> getTestRunAsync(final GetTestRunRequest getTestRunRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<TestRun>(){

            @Override
            public TestRun call() throws Exception {
                return TestExecutionServiceAsyncClient.this.getTestRun(getTestRunRequest);
            }
        });
    }

    @Override
    public Future<TestRun> getTestRunAsync(final GetTestRunRequest getTestRunRequest, final AsyncHandler<GetTestRunRequest, TestRun> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<TestRun>(){

            @Override
            public TestRun call() throws Exception {
                TestRun result;
                try {
                    result = TestExecutionServiceAsyncClient.this.getTestRun(getTestRunRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getTestRunRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<List<TestSuite>> listTestSuiteAsync(final ListTestSuiteRequest testSuiteRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<List<TestSuite>>(){

            @Override
            public List<TestSuite> call() throws Exception {
                return TestExecutionServiceAsyncClient.this.listTestSuite(testSuiteRequest);
            }
        });
    }

    @Override
    public Future<List<TestSuite>> listTestSuiteAsync(final ListTestSuiteRequest testSuiteRequest, final AsyncHandler<ListTestSuiteRequest, List<TestSuite>> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<List<TestSuite>>(){

            @Override
            public List<TestSuite> call() throws Exception {
                List<TestSuite> result;
                try {
                    result = TestExecutionServiceAsyncClient.this.listTestSuite(testSuiteRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(testSuiteRequest, result);
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdown();
    }
}

