/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.host;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.qas.api.AuthClientException;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.handler.AsyncHandler;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.services.host.HostServiceAsync;
import org.qas.qtest.api.services.host.HostServiceClient;
import org.qas.qtest.api.services.host.model.ActivateAutomationAgentRequest;
import org.qas.qtest.api.services.host.model.AutomationAgent;
import org.qas.qtest.api.services.host.model.AutomationHost;
import org.qas.qtest.api.services.host.model.CreateAutomationAgentRequest;
import org.qas.qtest.api.services.host.model.CreateAutomationHostRequest;
import org.qas.qtest.api.services.host.model.DeleteAutomationAgentRequest;
import org.qas.qtest.api.services.host.model.Job;
import org.qas.qtest.api.services.host.model.ListJobRequest;
import org.qas.qtest.api.services.host.model.PingAutomationHostRequest;
import org.qas.qtest.api.services.host.model.PongMessage;
import org.qas.qtest.api.services.host.model.UpdateAutomationAgentRequest;
import org.qas.qtest.api.services.host.model.UpdateJobStatusRequest;

public class HostServiceAsyncClient
extends HostServiceClient
implements HostServiceAsync {
    public HostServiceAsyncClient() {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration(), Executors.newCachedThreadPool());
    }

    public HostServiceAsyncClient(ExecutorService executorService) {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration(), executorService);
    }

    public HostServiceAsyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public HostServiceAsyncClient(ClientConfiguration clientConfiguration, ExecutorService executorService) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration, executorService);
    }

    public HostServiceAsyncClient(QTestCredentials credentials) {
        this(credentials, new ClientConfiguration(), Executors.newCachedThreadPool());
    }

    public HostServiceAsyncClient(QTestCredentials credentials, ExecutorService executorService) {
        this(credentials, new ClientConfiguration(), executorService);
    }

    public HostServiceAsyncClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
        this(credentials, clientConfiguration, Executors.newCachedThreadPool());
    }

    public HostServiceAsyncClient(QTestCredentials credentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        this(new StaticQTestCredentialsProvider(credentials), clientConfiguration, executorService);
    }

    public HostServiceAsyncClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this(credentialsProvider, clientConfiguration, Executors.newCachedThreadPool());
    }

    public HostServiceAsyncClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(credentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    @Override
    public Future<AutomationAgent> registerAutomationAgentAsync(final CreateAutomationAgentRequest automationAgentRequest) throws AuthClientException {
        return this.executorService.submit(new Callable<AutomationAgent>(){

            @Override
            public AutomationAgent call() throws Exception {
                return HostServiceAsyncClient.this.registerAutomationAgent(automationAgentRequest);
            }
        });
    }

    @Override
    public Future<AutomationAgent> registerAutomationAgentAsync(final CreateAutomationAgentRequest automationAgentRequest, final AsyncHandler<CreateAutomationAgentRequest, AutomationAgent> asyncHandler) throws AuthClientException {
        return this.executorService.submit(new Callable<AutomationAgent>(){

            @Override
            public AutomationAgent call() throws Exception {
                AutomationAgent result;
                try {
                    result = HostServiceAsyncClient.this.registerAutomationAgent(automationAgentRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(automationAgentRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<AutomationHost> registerAutomationHostAsync(final CreateAutomationHostRequest automationHostRequest) throws AuthClientException {
        return this.executorService.submit(new Callable<AutomationHost>(){

            @Override
            public AutomationHost call() throws Exception {
                return HostServiceAsyncClient.this.registerAutomationHost(automationHostRequest);
            }
        });
    }

    @Override
    public Future<AutomationHost> registerAutomationHostAsync(final CreateAutomationHostRequest automationHostRequest, final AsyncHandler<CreateAutomationHostRequest, AutomationHost> asyncHandler) throws AuthClientException {
        return this.executorService.submit(new Callable<AutomationHost>(){

            @Override
            public AutomationHost call() throws Exception {
                AutomationHost result;
                try {
                    result = HostServiceAsyncClient.this.registerAutomationHost(automationHostRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(automationHostRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<List<Job>> listJobsAsync(final ListJobRequest request) throws AuthClientException {
        return this.executorService.submit(new Callable<List<Job>>(){

            @Override
            public List<Job> call() throws Exception {
                return HostServiceAsyncClient.this.listJobs(request);
            }
        });
    }

    @Override
    public Future<List<Job>> listJobsAsync(final ListJobRequest request, final AsyncHandler<ListJobRequest, List<Job>> asyncHandler) throws AuthClientException {
        return this.executorService.submit(new Callable<List<Job>>(){

            @Override
            public List<Job> call() throws Exception {
                List<Job> result;
                try {
                    result = HostServiceAsyncClient.this.listJobs(request);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(request, result);
                return result;
            }
        });
    }

    @Override
    public Future<PongMessage> pingHostAsync(final PingAutomationHostRequest pingHostRequest) throws AuthClientException {
        return this.executorService.submit(new Callable<PongMessage>(){

            @Override
            public PongMessage call() throws Exception {
                return HostServiceAsyncClient.this.pingHost(pingHostRequest);
            }
        });
    }

    @Override
    public Future<PongMessage> pingHostAsync(final PingAutomationHostRequest pingHostRequest, final AsyncHandler<PingAutomationHostRequest, PongMessage> asyncHandler) throws AuthClientException {
        return this.executorService.submit(new Callable<PongMessage>(){

            @Override
            public PongMessage call() throws Exception {
                PongMessage result;
                try {
                    result = HostServiceAsyncClient.this.pingHost(pingHostRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(pingHostRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<AutomationAgent> updateAutomationAgentAsync(final UpdateAutomationAgentRequest automationAgentRequest) throws AuthClientException {
        return this.executorService.submit(new Callable<AutomationAgent>(){

            @Override
            public AutomationAgent call() throws Exception {
                return HostServiceAsyncClient.this.updateAutomationAgent(automationAgentRequest);
            }
        });
    }

    @Override
    public Future<AutomationAgent> updateAutomationAgentAsync(final UpdateAutomationAgentRequest automationAgentRequest, final AsyncHandler<UpdateAutomationAgentRequest, AutomationAgent> asyncHandler) throws AuthClientException {
        return this.executorService.submit(new Callable<AutomationAgent>(){

            @Override
            public AutomationAgent call() throws Exception {
                AutomationAgent result;
                try {
                    result = HostServiceAsyncClient.this.updateAutomationAgent(automationAgentRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(automationAgentRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Void> activateAutomationAgentAsync(final ActivateAutomationAgentRequest activateAgentRequest) throws AuthClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HostServiceAsyncClient.this.activateAutomationAgent(activateAgentRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> activateAutomationAgentAsync(final ActivateAutomationAgentRequest activateAgentRequest, final AsyncHandler<ActivateAutomationAgentRequest, Void> asyncHandler) throws AuthClientException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    HostServiceAsyncClient.this.activateAutomationAgent(activateAgentRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(activateAgentRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateJobStatusAsync(final UpdateJobStatusRequest updateJobStatusRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HostServiceAsyncClient.this.updateJobStatus(updateJobStatusRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> updateJobStatusAsync(final UpdateJobStatusRequest updateJobStatusRequest, final AsyncHandler<UpdateJobStatusRequest, Void> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    HostServiceAsyncClient.this.updateJobStatus(updateJobStatusRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(updateJobStatusRequest, null);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteAutomationAgentAsync(final DeleteAutomationAgentRequest deleteAutomationAgentRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HostServiceAsyncClient.this.deleteAutomationAgent(deleteAutomationAgentRequest);
                return null;
            }
        });
    }

    @Override
    public Future<Void> deleteAutomationAgentAsync(final DeleteAutomationAgentRequest deleteAutomationAgentRequest, final AsyncHandler<DeleteAutomationAgentRequest, Void> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                try {
                    HostServiceAsyncClient.this.deleteAutomationAgent(deleteAutomationAgentRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(deleteAutomationAgentRequest, null);
                return null;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdown();
    }
}

