/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.host;

import java.util.List;
import org.qas.api.AuthClientException;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.Request;
import org.qas.api.internal.util.google.base.Throwables;
import org.qas.api.transform.VoidJsonUnmarshaller;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.internal.QTestApiWebServiceClient;
import org.qas.qtest.api.services.host.HostService;
import org.qas.qtest.api.services.host.model.ActivateAutomationAgentRequest;
import org.qas.qtest.api.services.host.model.AutomationAgent;
import org.qas.qtest.api.services.host.model.AutomationHost;
import org.qas.qtest.api.services.host.model.CreateAutomationAgentRequest;
import org.qas.qtest.api.services.host.model.CreateAutomationHostRequest;
import org.qas.qtest.api.services.host.model.DeleteAutomationAgentRequest;
import org.qas.qtest.api.services.host.model.Job;
import org.qas.qtest.api.services.host.model.ListJobRequest;
import org.qas.qtest.api.services.host.model.PingAutomationHostRequest;
import org.qas.qtest.api.services.host.model.PongMessage;
import org.qas.qtest.api.services.host.model.UpdateAutomationAgentRequest;
import org.qas.qtest.api.services.host.model.UpdateAutomationHostRequest;
import org.qas.qtest.api.services.host.model.UpdateJobStatusRequest;
import org.qas.qtest.api.services.host.model.transform.ActivateAutomationAgentRequestMarshaller;
import org.qas.qtest.api.services.host.model.transform.AutomationAgentJsonUnmarshaller;
import org.qas.qtest.api.services.host.model.transform.AutomationHostJsonUnmarshaller;
import org.qas.qtest.api.services.host.model.transform.CreateAutomationAgentRequestMarshaller;
import org.qas.qtest.api.services.host.model.transform.CreateAutomationHostRequestMarshaller;
import org.qas.qtest.api.services.host.model.transform.DeleteAutomationAgentRequestMarshaller;
import org.qas.qtest.api.services.host.model.transform.ListJobJsonUnmarshaller;
import org.qas.qtest.api.services.host.model.transform.ListJobRequestMarshaller;
import org.qas.qtest.api.services.host.model.transform.PingAutomationHostRequestMarshaller;
import org.qas.qtest.api.services.host.model.transform.PongMessageJsonUnmarshaller;
import org.qas.qtest.api.services.host.model.transform.UpdateAutomationAgentRequestMarshaller;
import org.qas.qtest.api.services.host.model.transform.UpdateAutomationHostRequestMarshaller;
import org.qas.qtest.api.services.host.model.transform.UpdateJobStatusRequestMarshaller;

public class HostServiceClient
extends QTestApiWebServiceClient<HostServiceClient>
implements HostService {
    public HostServiceClient() {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration());
    }

    public HostServiceClient(ClientConfiguration clientConfiguration) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration);
    }

    public HostServiceClient(QTestCredentials credentials) {
        this(credentials, new ClientConfiguration());
    }

    public HostServiceClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = new StaticQTestCredentialsProvider(credentials);
        this.init();
    }

    public HostServiceClient(QTestCredentialsProvider credentialsProvider) {
        this(credentialsProvider, new ClientConfiguration());
    }

    public HostServiceClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = credentialsProvider;
        this.init();
    }

    @Override
    public AutomationHost registerAutomationHost(CreateAutomationHostRequest automationHostRequest) throws AuthServiceException {
        try {
            Object request = new CreateAutomationHostRequestMarshaller().marshall(automationHostRequest);
            return this.invoke((Request)request, AutomationHostJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during create automation host request", ex);
        }
    }

    @Override
    public AutomationHost updateAutomationHost(UpdateAutomationHostRequest automationHostRequest) throws AuthServiceException {
        try {
            Object request = new UpdateAutomationHostRequestMarshaller().marshall(automationHostRequest);
            return this.invoke((Request)request, AutomationHostJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during create automation host request", ex);
        }
    }

    @Override
    public AutomationAgent registerAutomationAgent(CreateAutomationAgentRequest automationAgentRequest) throws AuthClientException {
        try {
            Object request = new CreateAutomationAgentRequestMarshaller().marshall(automationAgentRequest);
            return this.invoke((Request)request, AutomationAgentJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during register automation agent request", ex);
        }
    }

    @Override
    public AutomationAgent updateAutomationAgent(UpdateAutomationAgentRequest automationAgentRequest) throws AuthClientException {
        try {
            Object request = new UpdateAutomationAgentRequestMarshaller().marshall(automationAgentRequest);
            return this.invoke((Request)request, AutomationAgentJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during update automation agent request", ex);
        }
    }

    @Override
    public void deleteAutomationAgent(DeleteAutomationAgentRequest deleteAutomationAgentRequest) throws AuthClientException {
        try {
            Object request = new DeleteAutomationAgentRequestMarshaller().marshall(deleteAutomationAgentRequest);
            this.invoke((Request)request, new VoidJsonUnmarshaller());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during delete automation agent request", ex);
        }
    }

    @Override
    public void activateAutomationAgent(ActivateAutomationAgentRequest activateAgentRequest) throws AuthClientException {
        try {
            Object request = new ActivateAutomationAgentRequestMarshaller().marshall(activateAgentRequest);
            this.invoke((Request)request, new VoidJsonUnmarshaller());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during activating agent.", ex);
        }
    }

    @Override
    public List<Job> listJobs(ListJobRequest jobRequest) throws AuthClientException {
        try {
            Object request = new ListJobRequestMarshaller().marshall(jobRequest);
            return this.invoke((Request)request, ListJobJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute create module request", ex);
        }
    }

    @Override
    public PongMessage pingHost(PingAutomationHostRequest pingRequest) throws AuthClientException {
        try {
            Object request = new PingAutomationHostRequestMarshaller().marshall(pingRequest);
            return this.invoke((Request)request, PongMessageJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during ping automation host request", ex);
        }
    }

    @Override
    public void updateJobStatus(UpdateJobStatusRequest updateJobStatusRequest) throws AuthServiceException {
        try {
            Object request = new UpdateJobStatusRequestMarshaller().marshall(updateJobStatusRequest);
            this.invoke((Request)request, new VoidJsonUnmarshaller());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during execute update job status request.", ex);
        }
    }
}

