/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.host.model.transform;

import java.util.Date;
import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.Dates;
import org.qas.api.internal.util.json.JsonObject;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.host.model.PingAutomationHostRequest;

public class PingAutomationHostRequestMarshaller
extends AbstractMarshaller<Request, PingAutomationHostRequest> {
    @Override
    protected void validateRequest(PingAutomationHostRequest in) throws Exception {
        if (in == null) {
            throw new AuthClientException("Invalid argument passed to marshall(...)");
        }
        if (in.getHostServerId() == null || in.getHostServerId() <= 0L) {
            throw new AuthClientException("Invalid automation host server identifier instance passed to marshall(...)");
        }
        if (in.getHostGuid() == null || "".equals(in.getHostGuid())) {
            throw new AuthClientException("Invalid automation host GUID instance passed to marshall(...)");
        }
    }

    @Override
    protected void build(Request request, PingAutomationHostRequest in) {
        request.setHttpMethod(HttpMethod.POST);
    }

    @Override
    protected String getServiceName() {
        return "HostService";
    }

    @Override
    protected String getActionName() {
        return "pingHost";
    }

    @Override
    protected String getContent(PingAutomationHostRequest in) throws Exception {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put("host_guid", in.getHostGuid());
        String isoDate = Dates.getInstance().formatAlternateIso8601Date(new Date());
        jsonObject.put("ping_time", isoDate);
        jsonObject.put("polling_frequency", in.getPollingFrequency());
        jsonObject.put("override", in.isOverride());
        jsonObject.put("host_version", in.getHostVersion());
        jsonObject.put("os", in.getOs());
        jsonObject.put("host_config", in.getHostConfig());
        jsonObject.put("port_config", in.getPortConfig());
        return jsonObject.toString();
    }

    @Override
    protected StringBuilder getResourcePath(PingAutomationHostRequest in, StringBuilder rpBuilder) {
        return rpBuilder.append("/api/v3/automation/hosts/").append(in.getHostServerId()).append("/ping");
    }
}

