/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.link.transform;

import org.apache.commons.collections.CollectionUtils;
import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.link.model.CreateArtifactLinkRequest;

public class CreateArtifactLinkMarshaller
extends AbstractMarshaller<Request, CreateArtifactLinkRequest> {
    @Override
    protected void validateRequest(CreateArtifactLinkRequest in) throws Exception {
        if (in == null) {
            throw new IllegalArgumentException("Invalid request");
        }
        if (in.getProjectId() == null || in.getProjectId() <= 0L) {
            throw new IllegalArgumentException("Invalid project id");
        }
        if (in.getSourceObjectType() == null) {
            throw new IllegalArgumentException("Invalid source artifact type id");
        }
        if (in.getDestObjectType() == null) {
            throw new IllegalArgumentException("Invalid dest artifact type id");
        }
        if (in.getDestArtifactId() == null || in.getDestArtifactId() <= 0L) {
            throw new IllegalArgumentException("Invalid dest artifact id");
        }
        if (CollectionUtils.isEmpty(in.getSourceArtifactIds())) {
            throw new IllegalArgumentException("Invalid source artifact ids");
        }
    }

    @Override
    protected void build(Request request, CreateArtifactLinkRequest in) {
        request.setHttpMethod(HttpMethod.POST);
    }

    @Override
    protected String getServiceName() {
        return "ArtifactLink";
    }

    @Override
    protected String getActionName() {
        return "CreateArtifactLink";
    }

    @Override
    protected String getContent(CreateArtifactLinkRequest in) {
        return JsonMapper.toJson(in.getSourceArtifactIds());
    }

    @Override
    protected StringBuilder getResourcePath(CreateArtifactLinkRequest in, StringBuilder rpBuilder) {
        rpBuilder.append(String.format("/api/v3/projects/%s/%s/%s/link?type=%s", in.getProjectId(), in.getDestObjectType().getPath(), in.getDestArtifactId(), in.getSourceObjectType().getPath()));
        return rpBuilder;
    }
}

