/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.project.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import org.qas.qtest.api.internal.model.QTestBaseModel;
import org.qas.qtest.api.services.project.model.Permissions;

public final class UserPermissions
extends QTestBaseModel<UserPermissions> {
    @JsonProperty(value="user_id")
    private Long userId;
    @JsonProperty(value="project_id")
    private Long projectId;

    public UserPermissions setUserId(Long userId) {
        this.userId = userId;
        return this;
    }

    public UserPermissions withUserId(Long userId) {
        this.setUserId(userId);
        return this;
    }

    public Long getUserId() {
        return this.userId;
    }

    public UserPermissions setProjectId(Long projectId) {
        this.projectId = projectId;
        return this;
    }

    public UserPermissions withProjectId(Long projectId) {
        this.setProjectId(projectId);
        return this;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public UserPermissions setPermissions(Permissions permissions) {
        if (permissions != null) {
            this.setProperty(permissions.getTypeName(), permissions.getPropertyMap());
        }
        return this;
    }

    public UserPermissions withPermissions(Permissions permissions) {
        this.setPermissions(permissions);
        return this;
    }

    public Permissions getPermissions(String name) {
        if (this.hasProperty(name) && this.getProperty(name) instanceof Map) {
            Map map = (Map)this.getProperty(name);
            Permissions permissions = new Permissions(map);
            permissions.setType(Permissions.PermissionType.resolve(name));
            return permissions;
        }
        return null;
    }

    public boolean hasPermission(String permission) {
        Permissions permissions;
        String type;
        if (permission.indexOf(95) >= 0 && (type = permission.substring(permission.lastIndexOf(95) + 1)) != null && this.hasProperty(type) && (permissions = this.getPermissions(type)) != null) {
            return permissions.hasPermission(permission.substring(0, permission.lastIndexOf(95)));
        }
        return false;
    }

    @Override
    public UserPermissions clone() {
        UserPermissions that = new UserPermissions();
        that.setPropertiesFrom(this);
        return that;
    }

    @Override
    public String jsonElementName() {
        return "user_permissions";
    }

    @Override
    public String elementName() {
        return "user-permissions";
    }
}

