/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.project.model.transform;

import org.apache.commons.collections.CollectionUtils;
import org.qas.api.AuthClientException;
import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.project.model.UpdateCustomFieldRequest;

public final class UpdateCustomFieldRequestMarshaller
extends AbstractMarshaller<Request, UpdateCustomFieldRequest> {
    @Override
    protected void validateRequest(UpdateCustomFieldRequest in) throws Exception {
        if (in == null) {
            throw new AuthClientException("Invalid request passed to call(...)");
        }
        if (in.getProjectId() == null || in.getProjectId() == 0L) {
            throw new AuthClientException("Invalid project identifier passed to call(...)");
        }
        if (in.getObjectType() == null) {
            throw new AuthClientException("Invalid object type passed to call(...)");
        }
        if (CollectionUtils.isEmpty(in.getFields())) {
            throw new AuthClientException("Invalid fields value passed to call(...)");
        }
    }

    @Override
    protected void build(Request request, UpdateCustomFieldRequest in) {
        request.setHttpMethod(HttpMethod.POST);
    }

    @Override
    protected String getServiceName() {
        return "ProjectService";
    }

    @Override
    protected String getActionName() {
        return "UpdateCustomField";
    }

    @Override
    protected String getContent(UpdateCustomFieldRequest in) {
        return JsonMapper.toJson(in.getFields());
    }

    @Override
    protected StringBuilder getResourcePath(UpdateCustomFieldRequest in, StringBuilder rpBuilder) {
        rpBuilder.append("/api/v3/projects/").append(in.getProjectId()).append("/settings/").append(in.getObjectType().getPath()).append("/custom-fields/active");
        return rpBuilder;
    }
}

