/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.requirement;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.handler.AsyncHandler;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.internal.model.CreateObjectCommentRequest;
import org.qas.qtest.api.internal.model.Field;
import org.qas.qtest.api.services.requirement.RequirementServiceAsync;
import org.qas.qtest.api.services.requirement.RequirementServiceClient;
import org.qas.qtest.api.services.requirement.model.CreateRequirementRequest;
import org.qas.qtest.api.services.requirement.model.GetRequirementFieldsRequest;
import org.qas.qtest.api.services.requirement.model.Requirement;

public class RequirementServiceAsyncClient
extends RequirementServiceClient
implements RequirementServiceAsync {
    public RequirementServiceAsyncClient() {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration(), Executors.newCachedThreadPool());
    }

    public RequirementServiceAsyncClient(ExecutorService executorService) {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration(), executorService);
    }

    public RequirementServiceAsyncClient(ClientConfiguration clientConfiguration) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration, Executors.newCachedThreadPool());
    }

    public RequirementServiceAsyncClient(ClientConfiguration clientConfiguration, ExecutorService executorService) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration, executorService);
    }

    public RequirementServiceAsyncClient(QTestCredentials credentials) {
        this(credentials, new ClientConfiguration(), Executors.newCachedThreadPool());
    }

    public RequirementServiceAsyncClient(QTestCredentials credentials, ExecutorService executorService) {
        this(credentials, new ClientConfiguration(), executorService);
    }

    public RequirementServiceAsyncClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
        this(credentials, clientConfiguration, Executors.newCachedThreadPool());
    }

    public RequirementServiceAsyncClient(QTestCredentials credentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        this(new StaticQTestCredentialsProvider(credentials), clientConfiguration, executorService);
    }

    public RequirementServiceAsyncClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        this(credentialsProvider, clientConfiguration, Executors.newCachedThreadPool());
    }

    public RequirementServiceAsyncClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(credentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    @Override
    public Future<List<Field>> getRequirementFieldsAsync(final GetRequirementFieldsRequest getRequirementFieldsRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<List<Field>>(){

            @Override
            public List<Field> call() throws Exception {
                return RequirementServiceAsyncClient.this.getRequirementFields(getRequirementFieldsRequest);
            }
        });
    }

    @Override
    public Future<List<Field>> getRequirementFieldsAsync(final GetRequirementFieldsRequest getRequirementFieldsRequest, final AsyncHandler<GetRequirementFieldsRequest, List<Field>> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<List<Field>>(){

            @Override
            public List<Field> call() throws Exception {
                List<Field> result;
                try {
                    result = RequirementServiceAsyncClient.this.getRequirementFields(getRequirementFieldsRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(getRequirementFieldsRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Requirement> createRequirementAsync(final CreateRequirementRequest createRequirementRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<Requirement>(){

            @Override
            public Requirement call() throws Exception {
                return RequirementServiceAsyncClient.this.createRequirement(createRequirementRequest);
            }
        });
    }

    @Override
    public Future<Requirement> createRequirementAsync(final CreateRequirementRequest createRequirementRequest, final AsyncHandler<CreateRequirementRequest, Requirement> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<Requirement>(){

            @Override
            public Requirement call() throws Exception {
                Requirement result;
                try {
                    result = RequirementServiceAsyncClient.this.createRequirement(createRequirementRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createRequirementRequest, result);
                return result;
            }
        });
    }

    @Override
    public Future<Requirement> addCommentAsync(final CreateObjectCommentRequest createObjectCommentRequest) throws AuthServiceException {
        return this.executorService.submit(new Callable<Requirement>(){

            @Override
            public Requirement call() throws Exception {
                return RequirementServiceAsyncClient.this.addComment(createObjectCommentRequest);
            }
        });
    }

    @Override
    public Future<Requirement> addCommentAsync(final CreateObjectCommentRequest createObjectCommentRequest, final AsyncHandler<CreateObjectCommentRequest, Requirement> asyncHandler) throws AuthServiceException {
        return this.executorService.submit(new Callable<Requirement>(){

            @Override
            public Requirement call() throws Exception {
                Requirement result;
                try {
                    result = RequirementServiceAsyncClient.this.addComment(createObjectCommentRequest);
                }
                catch (Exception ex) {
                    asyncHandler.onError(ex);
                    throw ex;
                }
                asyncHandler.onSuccess(createObjectCommentRequest, result);
                return result;
            }
        });
    }
}

