/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.requirement.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.requirement.model.CreateRequirementRequest;

public class CreateRequirementRequestMarshaller
extends AbstractMarshaller<Request, CreateRequirementRequest> {
    @Override
    protected void validateRequest(CreateRequirementRequest in) throws Exception {
        if (in == null) {
            throw new AuthClientException("Invalid argument passed to call(...)");
        }
        if (in.getProjectId() == null || in.getProjectId() <= 0L) {
            throw new AuthClientException("Invalid project identifier passed to call(...)");
        }
        if (in.getRequirement() == null) {
            throw new AuthClientException("Invalid requirement information passed to call(...)");
        }
    }

    @Override
    protected void build(Request request, CreateRequirementRequest in) {
        request.setHttpMethod(HttpMethod.POST);
        if (in.getParentId() != null) {
            request.addParameter("parentId", in.getParentId().toString());
        }
    }

    @Override
    protected String getServiceName() {
        return "RequirementService";
    }

    @Override
    protected String getActionName() {
        return "CreateRequirement";
    }

    @Override
    protected String getContent(CreateRequirementRequest in) throws Exception {
        return JsonMapper.toJson(in.getRequirement());
    }

    @Override
    protected StringBuilder getResourcePath(CreateRequirementRequest in, StringBuilder rpBuilder) {
        return rpBuilder.append("/api/v3/projects/").append(in.getProjectId()).append("/requirements");
    }
}

