/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.user.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.json.JsonArray;
import org.qas.api.internal.util.json.JsonObject;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.user.model.AssignToProjectRequest;

public class AssignToProjectRequestMarshaller
extends AbstractMarshaller<Request, AssignToProjectRequest> {
    @Override
    protected void validateRequest(AssignToProjectRequest in) throws Exception {
        if (in == null) {
            throw new AuthClientException("Invalid request passed to call(...)");
        }
        if (in.getProjectId() == null || in.getProjectId() == 0L) {
            throw new AuthClientException("Invalid project identifier passed to call(...)");
        }
        if (in.getUserIds() == null || in.getUserIds().isEmpty()) {
            throw new AuthClientException("Invalid user identifiers passed to call(...)");
        }
    }

    @Override
    protected void build(Request request, AssignToProjectRequest in) {
        request.setHttpMethod(HttpMethod.POST);
    }

    @Override
    protected String getServiceName() {
        return "UserService";
    }

    @Override
    protected String getActionName() {
        return "AssignToProject";
    }

    @Override
    protected String getContent(AssignToProjectRequest in) throws Exception {
        return new JsonObject().accumulate("project_id", in.getProjectId()).put("user_ids", new JsonArray(in.getUserIds())).toString();
    }

    @Override
    protected StringBuilder getResourcePath(AssignToProjectRequest in, StringBuilder rpBuilder) {
        return rpBuilder.append("/api/v3/users/projects");
    }
}

