/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cmq;

import com.qcloud.cmq.CMQClient;
import com.qcloud.cmq.CMQClientException;
import com.qcloud.cmq.CMQTool;
import com.qcloud.cmq.Queue;
import com.qcloud.cmq.QueueMeta;
import com.qcloud.cmq.Subscription;
import com.qcloud.cmq.Topic;
import com.qcloud.cmq.entity.CmqConfig;
import com.qcloud.cmq.json.JSONArray;
import com.qcloud.cmq.json.JSONObject;
import java.util.List;
import java.util.TreeMap;

public class Account {
    protected CMQClient client;

    public Account(String endpoint, String secretId, String secretKey) {
        CmqConfig cmqConfig = new CmqConfig();
        cmqConfig.setEndpoint(endpoint);
        cmqConfig.setSecretId(secretId);
        cmqConfig.setSecretKey(secretKey);
        this.client = new CMQClient(cmqConfig);
    }

    public Account(String secretId, String secretKey, String endpoint, String path, String method) {
        CmqConfig cmqConfig = new CmqConfig();
        cmqConfig.setEndpoint(endpoint);
        cmqConfig.setSecretId(secretId);
        cmqConfig.setSecretKey(secretKey);
        cmqConfig.setPath(path);
        cmqConfig.setMethod(method);
        this.client = new CMQClient(cmqConfig);
    }

    public Account(CmqConfig cmqConfig) {
        this.client = new CMQClient(cmqConfig);
    }

    public void setSignMethod(String Method2) {
        this.client.setSignMethod(Method2);
    }

    public void createQueue(String queueName, QueueMeta meta) throws Exception {
        TreeMap<String, String> param = new TreeMap<String, String>();
        if ("".equals(queueName)) {
            throw new CMQClientException("Invalid parameter:queueName is empty");
        }
        param.put("queueName", queueName);
        if (meta.maxMsgHeapNum > 0) {
            param.put("maxMsgHeapNum", Integer.toString(meta.maxMsgHeapNum));
        }
        if (meta.pollingWaitSeconds > 0) {
            param.put("pollingWaitSeconds", Integer.toString(meta.pollingWaitSeconds));
        }
        if (meta.visibilityTimeout > 0) {
            param.put("visibilityTimeout", Integer.toString(meta.visibilityTimeout));
        }
        if (meta.maxMsgSize > 0) {
            param.put("maxMsgSize", Integer.toString(meta.maxMsgSize));
        }
        if (meta.msgRetentionSeconds > 0) {
            param.put("msgRetentionSeconds", Integer.toString(meta.msgRetentionSeconds));
        }
        if (meta.rewindSeconds > 0) {
            param.put("rewindSeconds", Integer.toString(meta.rewindSeconds));
        }
        String result = this.client.call("CreateQueue", param);
        CMQTool.checkResult(result);
    }

    public void deleteQueue(String queueName) throws Exception {
        TreeMap<String, String> param = new TreeMap<String, String>();
        if ("".equals(queueName)) {
            throw new CMQClientException("Invalid parameter:queueName is empty");
        }
        param.put("queueName", queueName);
        String result = this.client.call("DeleteQueue", param);
        CMQTool.checkResult(result);
    }

    public int listQueue(String searchWord, int offset, int limit, List<String> queueList) throws Exception {
        TreeMap<String, String> param = new TreeMap<String, String>();
        if (!"".equals(searchWord)) {
            param.put("searchWord", searchWord);
        }
        if (offset >= 0) {
            param.put("offset", Integer.toString(offset));
        }
        if (limit > 0) {
            param.put("limit", Integer.toString(limit));
        }
        String result = this.client.call("ListQueue", param);
        CMQTool.checkResult(result);
        JSONObject jsonObj = new JSONObject(result);
        int totalCount = jsonObj.getInt("totalCount");
        JSONArray jsonArray = jsonObj.getJSONArray("queueList");
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject obj = (JSONObject)jsonArray.get(i);
            queueList.add(obj.getString("queueName"));
        }
        return totalCount;
    }

    public Queue getQueue(String queueName) {
        return new Queue(queueName, this.client);
    }

    public Topic getTopic(String topicName) {
        return new Topic(topicName, this.client);
    }

    public void createTopic(String topicName, int maxMsgSize) throws Exception {
        this.createTopic(topicName, maxMsgSize, 1);
    }

    public void createTopic(String topicName, int maxMsgSize, int filterType) throws Exception {
        TreeMap<String, String> param = new TreeMap<String, String>();
        if ("".equals(topicName)) {
            throw new CMQClientException("Invalid parameter:topicName is empty");
        }
        param.put("topicName", topicName);
        param.put("filterType", Integer.toString(filterType));
        if (maxMsgSize < 1024 || maxMsgSize > 0x100000) {
            throw new CMQClientException("Invalid parameter: maxMsgSize > 1024KB or maxMsgSize < 1KB");
        }
        param.put("maxMsgSize", Integer.toString(maxMsgSize));
        String result = this.client.call("CreateTopic", param);
        CMQTool.checkResult(result);
    }

    public void deleteTopic(String topicName) throws Exception {
        TreeMap<String, String> param = new TreeMap<String, String>();
        if ("".equals(topicName)) {
            throw new CMQClientException("Invalid parameter:topicName is empty");
        }
        param.put("topicName", topicName);
        String result = this.client.call("DeleteTopic", param);
        CMQTool.checkResult(result);
    }

    public int listTopic(String searchWord, List<String> vTopicList, int offset, int limit) throws Exception {
        TreeMap<String, String> param = new TreeMap<String, String>();
        if (!"".equals(searchWord)) {
            param.put("searchWord", searchWord);
        }
        if (offset >= 0) {
            param.put("offset", Integer.toString(offset));
        }
        if (limit > 0) {
            param.put("limit", Integer.toString(limit));
        }
        String result = this.client.call("ListTopic", param);
        CMQTool.checkResult(result);
        JSONObject jsonObj = new JSONObject(result);
        int totalCount = jsonObj.getInt("totalCount");
        JSONArray jsonArray = jsonObj.getJSONArray("topicList");
        vTopicList.clear();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject obj = (JSONObject)jsonArray.get(i);
            vTopicList.add(obj.getString("topicName"));
        }
        return totalCount;
    }

    public void createSubscribe(String topicName, String subscriptionName, String Endpoint, String Protocal) throws Exception {
        this.createSubscribe(topicName, subscriptionName, Endpoint, Protocal, null, null, "BACKOFF_RETRY", "JSON");
    }

    public void createSubscribe(String topicName, String subscriptionName, String Endpoint, String Protocal, List<String> FilterTag, List<String> bindingKey, String NotifyStrategy, String NotifyContentFormat) throws Exception {
        int i;
        if (FilterTag != null && FilterTag.size() > 5) {
            throw new CMQClientException("Invalid parameter: Tag number > 5");
        }
        TreeMap<String, String> param = new TreeMap<String, String>();
        if ("".equals(topicName)) {
            throw new CMQClientException("Invalid parameter:topicName is empty");
        }
        param.put("topicName", topicName);
        if ("".equals(subscriptionName)) {
            throw new CMQClientException("Invalid parameter:subscriptionName is empty");
        }
        param.put("subscriptionName", subscriptionName);
        if ("".equals(Endpoint)) {
            throw new CMQClientException("Invalid parameter:Endpoint is empty");
        }
        param.put("endpoint", Endpoint);
        if ("".equals(Protocal)) {
            throw new CMQClientException("Invalid parameter:Protocal is empty");
        }
        param.put("protocol", Protocal);
        if ("".equals(NotifyStrategy)) {
            throw new CMQClientException("Invalid parameter:NotifyStrategy is empty");
        }
        param.put("notifyStrategy", NotifyStrategy);
        if ("".equals(NotifyContentFormat)) {
            throw new CMQClientException("Invalid parameter:NotifyContentFormat is empty");
        }
        param.put("notifyContentFormat", NotifyContentFormat);
        if (FilterTag != null) {
            for (i = 0; i < FilterTag.size(); ++i) {
                param.put("filterTag." + Integer.toString(i + 1), FilterTag.get(i));
            }
        }
        if (bindingKey != null) {
            for (i = 0; i < bindingKey.size(); ++i) {
                param.put("bindingKey." + Integer.toString(i + 1), bindingKey.get(i));
            }
        }
        String result = this.client.call("Subscribe", param);
        CMQTool.checkResult(result);
    }

    public void deleteSubscribe(String topicName, String subscriptionName) throws Exception {
        TreeMap<String, String> param = new TreeMap<String, String>();
        if ("".equals(topicName)) {
            throw new CMQClientException("Invalid parameter:topicName is empty");
        }
        param.put("topicName", topicName);
        if ("".equals(subscriptionName)) {
            throw new CMQClientException("Invalid parameter:subscriptionName is empty");
        }
        param.put("subscriptionName", subscriptionName);
        String result = this.client.call("Unsubscribe", param);
        CMQTool.checkResult(result);
    }

    public Subscription getSubscription(String topicName, String subscriptionName) {
        return new Subscription(topicName, subscriptionName, this.client);
    }
}

