/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cmq;

import com.qcloud.cmq.entity.ActionProperties;
import com.qcloud.cmq.entity.CmqConfig;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);
    private static volatile OkHttpClient httpClient;
    private static volatile OkHttpClient receiveHttpClient;

    public static String request(String url, String data, CmqConfig cmqConfig, ActionProperties actionProperties) throws Exception {
        HttpUtil.initHttpClient(cmqConfig);
        String result = "";
        result = "POST".equals(cmqConfig.getMethod()) ? HttpUtil.httpPost(url, data, cmqConfig, actionProperties) : HttpUtil.httpGet(url, cmqConfig, actionProperties);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static void initHttpClient(CmqConfig cmqConfig) {
        Class<HttpUtil> clazz;
        if (httpClient == null) {
            clazz = HttpUtil.class;
            // MONITORENTER : com.qcloud.cmq.HttpUtil.class
            if (httpClient == null) {
                httpClient = new OkHttpClient().newBuilder().connectionPool(new ConnectionPool(cmqConfig.getMaxIdleConnections(), 5L, TimeUnit.MINUTES)).connectTimeout((long)cmqConfig.getConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)cmqConfig.getReadTimeout(), TimeUnit.MILLISECONDS).build();
            }
            // MONITOREXIT : clazz
        }
        if (receiveHttpClient != null) return;
        clazz = HttpUtil.class;
        // MONITORENTER : com.qcloud.cmq.HttpUtil.class
        if (receiveHttpClient == null) {
            receiveHttpClient = new OkHttpClient().newBuilder().connectionPool(new ConnectionPool(cmqConfig.getMaxIdleConnections(), 5L, TimeUnit.MINUTES)).connectTimeout((long)cmqConfig.getConnectTimeout(), TimeUnit.MILLISECONDS).readTimeout((long)cmqConfig.getReceiveTimeout(), TimeUnit.MILLISECONDS).build();
        }
        // MONITOREXIT : clazz
    }

    private static String httpGet(String url, CmqConfig cmqConfig, ActionProperties actionProperties) throws Exception {
        String result = null;
        Request request = new Request.Builder().url(url).build();
        if (log.isDebugEnabled()) {
            log.debug("request:{} timeout:{}", (Object)request.toString(), (Object)httpClient.readTimeoutMillis());
        }
        result = HttpUtil.doRequest(cmqConfig, request, actionProperties);
        return result;
    }

    private static String doRequest(CmqConfig cmqConfig, Request request, ActionProperties actionProperties) throws IOException {
        String result = null;
        Response response = null;
        long start = System.currentTimeMillis();
        try {
            if (ActionProperties.POLLING_OLD.equals(actionProperties.getActionType())) {
                int pollingWaitTime = actionProperties.getPollingWaitSeconds() >= 0 ? actionProperties.getPollingWaitSeconds() * 1000 : 0;
                OkHttpClient okHttpClient = new OkHttpClient().newBuilder().connectionPool(new ConnectionPool(1, 5L, TimeUnit.MINUTES)).connectTimeout((long)(cmqConfig.getConnectTimeout() + pollingWaitTime), TimeUnit.MILLISECONDS).readTimeout((long)(cmqConfig.getReadTimeout() + pollingWaitTime), TimeUnit.MILLISECONDS).build();
                response = okHttpClient.newCall(request).execute();
            } else {
                response = ActionProperties.POLLING.equals(actionProperties.getActionType()) ? receiveHttpClient.newCall(request).execute() : httpClient.newCall(request).execute();
            }
            result = response.body().string();
            long duration = System.currentTimeMillis() - start;
            if (cmqConfig.isAlwaysPrintResultLog()) {
                log.info("exec time: {},response:{}", (Object)duration, (Object)result);
            } else if (cmqConfig.isPrintSlow() && duration > cmqConfig.getSlowThreshold()) {
                log.warn("exec time: {},response:{}", (Object)duration, (Object)result);
            }
        }
        catch (Exception e) {
            long duration = System.currentTimeMillis() - start;
            log.error("request fail ,exec time: {}", (Object)duration, (Object)e);
            throw e;
        }
        return result;
    }

    private static String httpPost(String url, String data, CmqConfig cmqConfig, ActionProperties actionProperties) throws Exception {
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"*/*;charset=utf-8"), (String)data);
        Request request = new Request.Builder().url(url).post(requestBody).build();
        if (log.isDebugEnabled()) {
            log.debug("request:{} timeout:{} data:{}", new Object[]{request.toString(), httpClient.readTimeoutMillis(), data});
        }
        String result = HttpUtil.doRequest(cmqConfig, request, actionProperties);
        return result;
    }
}

