/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cmq;

import com.qcloud.cmq.CMQClient;
import com.qcloud.cmq.CMQClientException;
import com.qcloud.cmq.CMQServerException;
import com.qcloud.cmq.CMQTool;
import com.qcloud.cmq.Message;
import com.qcloud.cmq.QueueMeta;
import com.qcloud.cmq.entity.CmqResponse;
import com.qcloud.cmq.json.JSONArray;
import com.qcloud.cmq.json.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;

public class Queue {
    protected String queueName;
    protected CMQClient client;

    Queue(String queueName, CMQClient client) {
        this.queueName = queueName;
        this.client = client;
    }

    public void setQueueAttributes(QueueMeta meta) throws Exception {
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("queueName", this.queueName);
        if (meta.maxMsgHeapNum > 0) {
            param.put("maxMsgHeapNum", Integer.toString(meta.maxMsgHeapNum));
        }
        if (meta.pollingWaitSeconds > 0) {
            param.put("pollingWaitSeconds", Integer.toString(meta.pollingWaitSeconds));
        }
        if (meta.visibilityTimeout > 0) {
            param.put("visibilityTimeout", Integer.toString(meta.visibilityTimeout));
        }
        if (meta.maxMsgSize > 0) {
            param.put("maxMsgSize", Integer.toString(meta.maxMsgSize));
        }
        if (meta.msgRetentionSeconds > 0) {
            param.put("msgRetentionSeconds", Integer.toString(meta.msgRetentionSeconds));
        }
        if (meta.rewindSeconds > 0) {
            param.put("rewindSeconds", Integer.toString(meta.rewindSeconds));
        }
        String result = this.client.call("SetQueueAttributes", param);
        CMQTool.checkResult(result);
    }

    public QueueMeta getQueueAttributes() throws Exception {
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("queueName", this.queueName);
        String result = this.client.call("GetQueueAttributes", param);
        JSONObject jsonObj = new JSONObject(result);
        CMQTool.checkResult(result);
        QueueMeta meta = new QueueMeta();
        meta.maxMsgHeapNum = jsonObj.getInt("maxMsgHeapNum");
        meta.pollingWaitSeconds = jsonObj.getInt("pollingWaitSeconds");
        meta.visibilityTimeout = jsonObj.getInt("visibilityTimeout");
        meta.maxMsgSize = jsonObj.getInt("maxMsgSize");
        meta.msgRetentionSeconds = jsonObj.getInt("msgRetentionSeconds");
        meta.createTime = jsonObj.getInt("createTime");
        meta.lastModifyTime = jsonObj.getInt("lastModifyTime");
        meta.activeMsgNum = jsonObj.getInt("activeMsgNum");
        meta.inactiveMsgNum = jsonObj.getInt("inactiveMsgNum");
        meta.rewindmsgNum = jsonObj.getInt("rewindMsgNum");
        meta.minMsgTime = jsonObj.getInt("minMsgTime");
        meta.delayMsgNum = jsonObj.getInt("delayMsgNum");
        meta.rewindSeconds = jsonObj.getInt("rewindSeconds");
        return meta;
    }

    @Deprecated
    public String sendMessage(String msgBody) throws Exception {
        return this.sendMessage(msgBody, 0);
    }

    @Deprecated
    public String sendMessage(String msgBody, int delayTime) throws Exception {
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("queueName", this.queueName);
        param.put("msgBody", msgBody);
        param.put("delaySeconds", Integer.toString(delayTime));
        String result = this.client.call("SendMessage", param);
        JSONObject jsonObj = new JSONObject(result);
        CMQTool.checkResult(result);
        return jsonObj.getString("msgId");
    }

    public CmqResponse send(String msgBody) throws Exception {
        return this.send(msgBody, 0);
    }

    public CmqResponse send(String msgBody, int delayTime) throws Exception {
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("queueName", this.queueName);
        param.put("msgBody", msgBody);
        param.put("delaySeconds", Integer.toString(delayTime));
        String result = this.client.call("SendMessage", param);
        JSONObject jsonObj = new JSONObject(result);
        CMQTool.checkResult(result);
        CmqResponse cmqResponse = new CmqResponse();
        cmqResponse.setCode(jsonObj.getInt("code"));
        cmqResponse.setMsgId(jsonObj.getString("msgId"));
        cmqResponse.setRequestId(jsonObj.getString("requestId"));
        return cmqResponse;
    }

    @Deprecated
    public List<String> batchSendMessage(List<String> vtMsgBody) throws Exception {
        return this.batchSendMessage(vtMsgBody, 0);
    }

    @Deprecated
    public List<String> batchSendMessage(List<String> vtMsgBody, int delayTime) throws Exception {
        if (vtMsgBody.isEmpty() || vtMsgBody.size() > 16) {
            throw new CMQClientException("Error: message size is empty or more than 16");
        }
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("queueName", this.queueName);
        for (int i = 0; i < vtMsgBody.size(); ++i) {
            String k = "msgBody." + Integer.toString(i + 1);
            param.put(k, vtMsgBody.get(i));
        }
        param.put("delaySeconds", Integer.toString(delayTime));
        String result = this.client.call("BatchSendMessage", param);
        JSONObject jsonObj = new JSONObject(result);
        CMQTool.checkResult(result);
        ArrayList<String> vtMsgId = new ArrayList<String>();
        JSONArray jsonArray = jsonObj.getJSONArray("msgList");
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject obj = (JSONObject)jsonArray.get(i);
            vtMsgId.add(obj.getString("msgId"));
        }
        return vtMsgId;
    }

    public List<CmqResponse> batchSend(List<String> vtMsgBody) throws Exception {
        return this.batchSend(vtMsgBody, 0);
    }

    public List<CmqResponse> batchSend(List<String> vtMsgBody, int delayTime) throws Exception {
        if (vtMsgBody.isEmpty() || vtMsgBody.size() > 16) {
            throw new CMQClientException("Error: message size is empty or more than 16");
        }
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("queueName", this.queueName);
        for (int i = 0; i < vtMsgBody.size(); ++i) {
            String k = "msgBody." + (i + 1);
            param.put(k, vtMsgBody.get(i));
        }
        param.put("delaySeconds", Integer.toString(delayTime));
        String result = this.client.call("BatchSendMessage", param);
        JSONObject jsonObj = new JSONObject(result);
        CMQTool.checkResult(result);
        ArrayList<CmqResponse> cmqResponses = new ArrayList<CmqResponse>();
        JSONArray jsonArray = jsonObj.getJSONArray("msgList");
        String requestId = jsonObj.getString("requestId");
        int code = jsonObj.getInt("code");
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject obj = (JSONObject)jsonArray.get(i);
            CmqResponse cmqResponse = new CmqResponse();
            cmqResponse.setRequestId(requestId);
            cmqResponse.setMsgId(obj.getString("msgId"));
            cmqResponse.setCode(code);
            cmqResponses.add(cmqResponse);
        }
        return cmqResponses;
    }

    @Deprecated
    public Message receiveMessage(int pollingWaitSeconds) throws Exception {
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("queueName", this.queueName);
        if (pollingWaitSeconds >= 0) {
            param.put("pollingWaitSeconds", Integer.toString(pollingWaitSeconds));
        } else {
            param.put("pollingWaitSeconds", Integer.toString(30000));
        }
        String result = this.client.call("ReceiveMessage", param);
        JSONObject jsonObj = new JSONObject(result);
        int code = jsonObj.getInt("code");
        if (code != 0) {
            throw new CMQServerException(code, jsonObj.getString("message"));
        }
        Message msg = new Message();
        msg.msgId = jsonObj.getString("msgId");
        msg.receiptHandle = jsonObj.getString("receiptHandle");
        msg.msgBody = jsonObj.getString("msgBody");
        msg.enqueueTime = jsonObj.getLong("enqueueTime");
        msg.nextVisibleTime = jsonObj.getLong("nextVisibleTime");
        msg.firstDequeueTime = jsonObj.getLong("firstDequeueTime");
        msg.dequeueCount = jsonObj.getInt("dequeueCount");
        return msg;
    }

    @Deprecated
    public List<Message> batchReceiveMessage(int numOfMsg, int pollingWaitSeconds) throws Exception {
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("queueName", this.queueName);
        param.put("numOfMsg", Integer.toString(numOfMsg));
        if (pollingWaitSeconds >= 0) {
            param.put("pollingWaitSeconds", Integer.toString(pollingWaitSeconds));
        } else {
            param.put("pollingWaitSeconds", Integer.toString(30000));
        }
        String result = this.client.call("BatchReceiveMessage", param);
        JSONObject jsonObj = new JSONObject(result);
        int code = jsonObj.getInt("code");
        if (code != 0) {
            throw new CMQServerException(code, jsonObj.getString("message"));
        }
        ArrayList<Message> vtMessage = new ArrayList<Message>();
        JSONArray jsonArray = jsonObj.getJSONArray("msgInfoList");
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject obj = (JSONObject)jsonArray.get(i);
            Message msg = new Message();
            msg.msgId = obj.getString("msgId");
            msg.receiptHandle = obj.getString("receiptHandle");
            msg.msgBody = obj.getString("msgBody");
            msg.enqueueTime = obj.getLong("enqueueTime");
            msg.nextVisibleTime = obj.getLong("nextVisibleTime");
            msg.firstDequeueTime = obj.getLong("firstDequeueTime");
            msg.dequeueCount = obj.getInt("dequeueCount");
            vtMessage.add(msg);
        }
        return vtMessage;
    }

    public Message receiveMessage() throws Exception {
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("queueName", this.queueName);
        String result = this.client.call("ReceiveMessage", param);
        JSONObject jsonObj = new JSONObject(result);
        CMQTool.checkResult(result);
        Message msg = new Message();
        msg.msgId = jsonObj.getString("msgId");
        msg.receiptHandle = jsonObj.getString("receiptHandle");
        msg.msgBody = jsonObj.getString("msgBody");
        msg.enqueueTime = jsonObj.getLong("enqueueTime");
        msg.nextVisibleTime = jsonObj.getLong("nextVisibleTime");
        msg.firstDequeueTime = jsonObj.getLong("firstDequeueTime");
        msg.dequeueCount = jsonObj.getInt("dequeueCount");
        msg.requestId = jsonObj.getString("requestId");
        return msg;
    }

    public List<Message> batchReceiveMessage(int numOfMsg) throws Exception {
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("queueName", this.queueName);
        param.put("numOfMsg", Integer.toString(numOfMsg));
        String result = this.client.call("BatchReceiveMessage", param);
        JSONObject jsonObj = new JSONObject(result);
        CMQTool.checkResult(result);
        ArrayList<Message> vtMessage = new ArrayList<Message>();
        JSONArray jsonArray = jsonObj.getJSONArray("msgInfoList");
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject obj = (JSONObject)jsonArray.get(i);
            Message msg = new Message();
            msg.msgId = obj.getString("msgId");
            msg.receiptHandle = obj.getString("receiptHandle");
            msg.msgBody = obj.getString("msgBody");
            msg.enqueueTime = obj.getLong("enqueueTime");
            msg.nextVisibleTime = obj.getLong("nextVisibleTime");
            msg.firstDequeueTime = obj.getLong("firstDequeueTime");
            msg.dequeueCount = obj.getInt("dequeueCount");
            msg.requestId = jsonObj.getString("requestId");
            vtMessage.add(msg);
        }
        return vtMessage;
    }

    public CmqResponse deleteMessage(String receiptHandle) throws Exception {
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("queueName", this.queueName);
        param.put("receiptHandle", receiptHandle);
        String result = this.client.call("DeleteMessage", param);
        CMQTool.checkResult(result);
        JSONObject jsonObject = new JSONObject(result);
        CmqResponse cmqResponse = new CmqResponse();
        cmqResponse.setRequestId(jsonObject.getString("requestId"));
        return cmqResponse;
    }

    public void batchDeleteMessage(List<String> vtReceiptHandle) throws Exception {
        if (vtReceiptHandle.isEmpty()) {
            return;
        }
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("queueName", this.queueName);
        for (int i = 0; i < vtReceiptHandle.size(); ++i) {
            String k = "receiptHandle." + (i + 1);
            param.put(k, vtReceiptHandle.get(i));
        }
        String result = this.client.call("BatchDeleteMessage", param);
        CMQTool.checkResult(result);
    }

    public void rewindQueue(int backTrackingTime) throws Exception {
        if (backTrackingTime <= 0) {
            return;
        }
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("queueName", this.queueName);
        param.put("startConsumeTime", Integer.toString(backTrackingTime));
        String result = this.client.call("RewindQueue", param);
        CMQTool.checkResult(result);
    }
}

