/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cmq;

import com.qcloud.cmq.CMQClient;
import com.qcloud.cmq.CMQTool;
import com.qcloud.cmq.SubscriptionMeta;
import com.qcloud.cmq.json.JSONArray;
import com.qcloud.cmq.json.JSONObject;
import java.util.TreeMap;
import java.util.Vector;

public class Subscription {
    protected String topicName;
    protected String subscriptionName;
    protected CMQClient client;

    Subscription(String topicName, String subscriptionName, CMQClient client) {
        this.topicName = topicName;
        this.subscriptionName = subscriptionName;
        this.client = client;
    }

    public void ClearFilterTags() throws Exception {
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("topicName", this.topicName);
        param.put("subscriptionName", this.subscriptionName);
        String result = this.client.call("ClearSUbscriptionFIlterTags", param);
        CMQTool.checkResult(result);
    }

    public void SetSubscriptionAttributes(SubscriptionMeta meta) throws Exception {
        int n;
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("topicName", this.topicName);
        param.put("subscriptionName", this.subscriptionName);
        if (!"".equals(meta.NotifyStrategy)) {
            param.put("notifyStrategy", meta.NotifyStrategy);
        }
        if (!"".equals(meta.NotifyContentFormat)) {
            param.put("notifyContentFormat", meta.NotifyContentFormat);
        }
        if (meta.FilterTag != null) {
            n = 1;
            for (String flag : meta.FilterTag) {
                param.put("filterTag." + Integer.toString(n), flag);
                ++n;
            }
        }
        if (meta.bindingKey != null) {
            n = 1;
            for (String flag : meta.bindingKey) {
                param.put("bindingKey." + Integer.toString(n), flag);
                ++n;
            }
        }
        String result = this.client.call("SetSubscriptionAttributes", param);
        CMQTool.checkResult(result);
    }

    public SubscriptionMeta getSubscriptionAttributes() throws Exception {
        int i;
        JSONArray jsonArray;
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("topicName", this.topicName);
        param.put("subscriptionName", this.subscriptionName);
        String result = this.client.call("GetSubscriptionAttributes", param);
        JSONObject jsonObj = new JSONObject(result);
        CMQTool.checkResult(result);
        SubscriptionMeta meta = new SubscriptionMeta();
        meta.FilterTag = new Vector();
        if (jsonObj.has("endpoint")) {
            meta.Endpoint = jsonObj.getString("endpoint");
        }
        if (jsonObj.has("notifyStrategy")) {
            meta.NotifyStrategy = jsonObj.getString("notifyStrategy");
        }
        if (jsonObj.has("notifyContentFormat")) {
            meta.NotifyContentFormat = jsonObj.getString("notifyContentFormat");
        }
        if (jsonObj.has("protocol")) {
            meta.Protocal = jsonObj.getString("protocol");
        }
        if (jsonObj.has("createTime")) {
            meta.CreateTime = jsonObj.getInt("createTime");
        }
        if (jsonObj.has("lastModifyTime")) {
            meta.LastModifyTime = jsonObj.getInt("lastModifyTime");
        }
        if (jsonObj.has("msgCount")) {
            meta.msgCount = jsonObj.getInt("msgCount");
        }
        if (jsonObj.has("filterTag")) {
            jsonArray = jsonObj.getJSONArray("filterTag");
            if (jsonArray.length() > 0 && meta.FilterTag == null) {
                meta.FilterTag = new Vector();
            }
            for (i = 0; i < jsonArray.length(); ++i) {
                meta.FilterTag.add(jsonArray.getString(i));
            }
        }
        if (jsonObj.has("bindingKey")) {
            jsonArray = jsonObj.getJSONArray("bindingKey");
            if (jsonArray.length() > 0 && meta.bindingKey == null) {
                meta.bindingKey = new Vector();
            }
            for (i = 0; i < jsonArray.length(); ++i) {
                meta.bindingKey.add(jsonArray.getString(i));
            }
        }
        return meta;
    }
}

