/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cmq;

import com.qcloud.cmq.CMQClient;
import com.qcloud.cmq.CMQClientException;
import com.qcloud.cmq.CMQTool;
import com.qcloud.cmq.TopicMeta;
import com.qcloud.cmq.json.JSONArray;
import com.qcloud.cmq.json.JSONObject;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;

public class Topic {
    protected String topicName;
    protected CMQClient client;

    Topic(String topicName, CMQClient client) {
        this.topicName = topicName;
        this.client = client;
    }

    public void setTopicAttributes(int maxMsgSize) throws Exception {
        if (maxMsgSize < 1024 || maxMsgSize > 0x100000) {
            throw new CMQClientException("Invalid parameter maxMsgSize < 1KB or maxMsgSize > 1024KB");
        }
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("topicName", this.topicName);
        if (maxMsgSize > 0) {
            param.put("maxMsgSize", Integer.toString(maxMsgSize));
        }
        String result = this.client.call("SetTopicAttributes", param);
        CMQTool.checkResult(result);
    }

    public TopicMeta getTopicAttributes() throws Exception {
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("topicName", this.topicName);
        String result = this.client.call("GetTopicAttributes", param);
        JSONObject jsonObj = new JSONObject(result);
        CMQTool.checkResult(result);
        TopicMeta meta = new TopicMeta();
        meta.msgCount = jsonObj.getInt("msgCount");
        meta.maxMsgSize = jsonObj.getInt("maxMsgSize");
        meta.msgRetentionSeconds = jsonObj.getInt("msgRetentionSeconds");
        meta.createTime = jsonObj.getInt("createTime");
        meta.lastModifyTime = jsonObj.getInt("lastModifyTime");
        meta.filterType = jsonObj.getInt("filterType");
        return meta;
    }

    public String publishMessage(String message) throws Exception {
        return this.publishMessage(message, null, null);
    }

    public String publishMessage(String message, String routingKey) throws Exception {
        return this.publishMessage(message, null, routingKey);
    }

    public String publishMessage(String msg, List<String> vTagList, String routingKey) throws Exception {
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("topicName", this.topicName);
        param.put("msgBody", msg);
        if (routingKey != null) {
            param.put("routingKey", routingKey);
        }
        if (vTagList != null) {
            for (int i = 0; i < vTagList.size(); ++i) {
                param.put("msgTag." + Integer.toString(i + 1), vTagList.get(i));
            }
        }
        String result = this.client.call("PublishMessage", param);
        JSONObject jsonObj = new JSONObject(result);
        CMQTool.checkResult(result);
        return jsonObj.getString("msgId");
    }

    public Vector<String> batchPublishMessage(List<String> vMsgList) throws Exception {
        return this.batchPublishMessage(vMsgList, null, null);
    }

    public Vector<String> batchPublishMessage(List<String> vMsgList, String routingKey) throws Exception {
        return this.batchPublishMessage(vMsgList, null, routingKey);
    }

    public Vector<String> batchPublishMessage(List<String> vMsgList, List<String> vTagList, String routingKey) throws Exception {
        int i;
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("topicName", this.topicName);
        if (routingKey != null) {
            param.put("routingKey", routingKey);
        }
        if (vMsgList != null) {
            for (i = 0; i < vMsgList.size(); ++i) {
                param.put("msgBody." + Integer.toString(i + 1), vMsgList.get(i));
            }
        }
        if (vTagList != null) {
            for (i = 0; i < vTagList.size(); ++i) {
                param.put("msgTag." + Integer.toString(i + 1), vTagList.get(i));
            }
        }
        String result = this.client.call("BatchPublishMessage", param);
        JSONObject jsonObj = new JSONObject(result);
        CMQTool.checkResult(result);
        JSONArray jsonArray = jsonObj.getJSONArray("msgList");
        Vector<String> vmsgId = new Vector<String>();
        for (int i2 = 0; i2 < jsonArray.length(); ++i2) {
            JSONObject obj = (JSONObject)jsonArray.get(i2);
            vmsgId.add(obj.getString("msgId"));
        }
        return vmsgId;
    }

    public int ListSubscription(int offset, int limit, String searchWord, List<String> vSubscriptionList) throws Exception {
        TreeMap<String, String> param = new TreeMap<String, String>();
        param.put("topicName", this.topicName);
        if (searchWord != null && !"".equals(searchWord)) {
            param.put("searchWord", searchWord);
        }
        if (offset >= 0) {
            param.put("offset", Integer.toString(offset));
        }
        if (limit > 0) {
            param.put("limit", Integer.toString(limit));
        }
        String result = this.client.call("ListSubscriptionByTopic", param);
        JSONObject jsonObj = new JSONObject(result);
        CMQTool.checkResult(result);
        int totalCount = jsonObj.getInt("totalCount");
        if (!jsonObj.has("subscriptionList")) {
            return 0;
        }
        JSONArray jsonArray = jsonObj.getJSONArray("subscriptionList");
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject obj = (JSONObject)jsonArray.get(i);
            vSubscriptionList.add(obj.getString("subscriptionName"));
        }
        return totalCount;
    }
}

