/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cmq.example;

import com.qcloud.cmq.Account;
import com.qcloud.cmq.CMQClientException;
import com.qcloud.cmq.CMQServerException;
import com.qcloud.cmq.Subscription;
import com.qcloud.cmq.SubscriptionMeta;
import com.qcloud.cmq.Topic;
import com.qcloud.cmq.TopicMeta;
import java.util.ArrayList;
import java.util.Vector;

public class TopicDemo {
    public static void main(String[] args) {
        String secretId = "";
        String secretKey = "";
        String endpoint = "https://cmq-topic-{$region}.api.qcloud.com";
        try {
            int batchMessageSize = 5;
            System.out.println("---------------- init account ----------------");
            Account account = new Account(endpoint, secretId, secretKey);
            System.out.println("---------------- get topic ----------------");
            String topicName = "qiyuan-test";
            Topic topic = account.getTopic(topicName);
            Thread.sleep(1000L);
            System.out.println("---------------- set and get topic meta ----------------");
            TopicMeta topicMeta = new TopicMeta();
            topicMeta.maxMsgSize = 32768;
            topic.setTopicAttributes(topicMeta.maxMsgSize);
            topicMeta = topic.getTopicAttributes();
            System.out.println("maxMsgSize: " + topicMeta.maxMsgSize);
            System.out.println("createTime: " + topicMeta.createTime);
            System.out.println("lastModifyTime: " + topicMeta.lastModifyTime);
            System.out.println("msgCount: " + topicMeta.msgCount);
            System.out.println("---------------- get sub ----------------");
            String subscriptionName = "qiyuan-test-sub";
            Subscription sub = account.getSubscription(topicName, subscriptionName);
            SubscriptionMeta subscriptionMeta = sub.getSubscriptionAttributes();
            System.out.println("Endpoint: " + subscriptionMeta.Endpoint);
            System.out.println("Protocal " + subscriptionMeta.Protocal);
            System.out.println("TopicOwner: " + subscriptionMeta.TopicOwner);
            System.out.println("CreateTime: " + subscriptionMeta.CreateTime);
            System.out.println("msgCount: " + subscriptionMeta.msgCount);
            System.out.println("---------------- list sub ----------------");
            ArrayList<String> vSubscription = new ArrayList<String>();
            int SubscriptionCount = topic.ListSubscription(-1, -1, "", vSubscription);
            for (String subscription : vSubscription) {
                System.out.println("Subscription name :" + subscription);
            }
            System.out.println("---------------- publish message ----------------");
            String msg = "hello!";
            String msgId = topic.publishMessage(msg);
            System.out.println("msgId: " + msgId);
            System.out.println("---------------- batch publish message ----------------");
            Vector<String> vMsg = new Vector<String>();
            for (int i = 0; i < batchMessageSize; ++i) {
                String msgItem = "this is a test message publish with index = " + i;
                vMsg.add(msgItem);
            }
            Vector<String> msgIds = topic.batchPublishMessage(vMsg);
            System.out.println("msgIds: " + msgIds.toString());
        }
        catch (CMQServerException e1) {
            System.out.println("Server Exception, " + e1.toString());
        }
        catch (CMQClientException e2) {
            System.out.println("Client Exception, " + e2.toString());
        }
        catch (Exception e) {
            System.out.println("error..." + e.toString());
        }
    }
}

