/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cmq.client.client;

import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import com.qcloud.cmq.client.client.CMQClientHandler;
import com.qcloud.cmq.client.common.ClientConfig;
import com.qcloud.cmq.client.common.LogHelper;
import com.qcloud.cmq.client.common.NettyClientConfig;
import com.qcloud.cmq.client.common.RequestIdHelper;
import com.qcloud.cmq.client.common.SignTool;
import com.qcloud.cmq.client.consumer.BatchDeleteCallback;
import com.qcloud.cmq.client.consumer.BatchDeleteResult;
import com.qcloud.cmq.client.consumer.BatchReceiveCallback;
import com.qcloud.cmq.client.consumer.BatchReceiveResult;
import com.qcloud.cmq.client.consumer.DeleteCallback;
import com.qcloud.cmq.client.consumer.DeleteResult;
import com.qcloud.cmq.client.consumer.ReceiptHandleErrorInfo;
import com.qcloud.cmq.client.consumer.ReceiveCallback;
import com.qcloud.cmq.client.consumer.ReceiveResult;
import com.qcloud.cmq.client.exception.MQClientException;
import com.qcloud.cmq.client.exception.MQServerException;
import com.qcloud.cmq.client.netty.CommunicationMode;
import com.qcloud.cmq.client.netty.InvokeCallback;
import com.qcloud.cmq.client.netty.NettyClient;
import com.qcloud.cmq.client.netty.RemoteException;
import com.qcloud.cmq.client.netty.RemoteTooMuchRequestException;
import com.qcloud.cmq.client.netty.ResponseFuture;
import com.qcloud.cmq.client.producer.BatchPublishCallback;
import com.qcloud.cmq.client.producer.BatchPublishResult;
import com.qcloud.cmq.client.producer.BatchSendCallback;
import com.qcloud.cmq.client.producer.BatchSendResult;
import com.qcloud.cmq.client.producer.ProducerImpl;
import com.qcloud.cmq.client.producer.PublishCallback;
import com.qcloud.cmq.client.producer.PublishResult;
import com.qcloud.cmq.client.producer.SendCallback;
import com.qcloud.cmq.client.producer.SendResult;
import com.qcloud.cmq.client.protocol.Cmq;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;

public class CMQClient {
    private static final Logger logger = LogHelper.getLog();
    private ClientConfig clientConfig;
    private String clientId;
    private final NettyClient nettyClient;

    public CMQClient(NettyClientConfig nettyClientConfig, CMQClientHandler cMQClientHandler, ClientConfig clientConfig, String clientId) {
        this.clientConfig = clientConfig;
        this.clientId = clientId;
        this.nettyClient = new NettyClient(nettyClientConfig, cMQClientHandler);
    }

    public void start() {
        this.nettyClient.setAuthData(this.createAuthData());
        this.nettyClient.start();
    }

    public void shutdown() {
        this.nettyClient.shutdown();
    }

    private Cmq.cmq_tcp_auth createAuthData() {
        String signature;
        try {
            signature = SignTool.sign(this.clientId + this.clientConfig.getSecretId(), this.clientConfig.getSecretKey(), this.clientConfig.getSignMethod());
        }
        catch (Exception e) {
            logger.error("create auth data error.", (Throwable)e);
            return null;
        }
        return Cmq.cmq_tcp_auth.newBuilder().setClientId(this.clientId).setSecretId(this.clientConfig.getSecretId()).setSignatureMethod(this.clientConfig.getSignMethod()).setSignature(signature).build();
    }

    public SendResult sendMessage(List<String> accessList, Cmq.CMQProto request, long timeoutMillis, CommunicationMode communicationMode, SendCallback sendCallback, int retryTimesWhenSendFailed, ProducerImpl producer) throws InterruptedException, RemoteException {
        switch (communicationMode) {
            case SYNC: {
                return this.sendMessageSync(accessList, request, timeoutMillis);
            }
            case ASYNC: {
                AtomicInteger times = new AtomicInteger();
                this.sendMessageAsync(accessList, timeoutMillis, request, sendCallback, retryTimesWhenSendFailed, times, producer);
                return null;
            }
            case ONEWAY: {
                this.nettyClient.invokeOneWay(accessList, request, timeoutMillis);
                return null;
            }
        }
        assert (false);
        return null;
    }

    private SendResult sendMessageSync(List<String> addressList, Cmq.CMQProto request, long timeoutMillis) throws InterruptedException, RemoteException {
        Cmq.CMQProto response = this.nettyClient.invokeSync(addressList, request, timeoutMillis);
        assert (response != null);
        return this.processSendResponse(response);
    }

    private void sendMessageAsync(final List<String> accessList, final long timeoutMillis, final Cmq.CMQProto request, final SendCallback sendCallback, final int retryTimesWhenSendFailed, final AtomicInteger times, final ProducerImpl producer) throws InterruptedException, RemoteException {
        this.nettyClient.invokeAsync(accessList, request, timeoutMillis, new InvokeCallback(){

            @Override
            public void operationComplete(ResponseFuture responseFuture) {
                Cmq.CMQProto response = responseFuture.getResponseCommand();
                if (response != null) {
                    SendResult sendResult = CMQClient.this.processSendResponse(response);
                    if (sendCallback != null) {
                        try {
                            sendCallback.onSuccess(sendResult);
                        }
                        catch (Throwable throwable) {}
                    }
                } else {
                    MQClientException ex = new MQClientException(responseFuture.getErrorMsg("sendMessageAsync"), responseFuture.getCause());
                    CMQClient.this.onExceptionImpl((List<String>)accessList, timeoutMillis, request, sendCallback, retryTimesWhenSendFailed, times, ex, true, producer);
                }
            }
        });
    }

    private void onExceptionImpl(List<String> accessList, long timeoutMillis, Cmq.CMQProto request, SendCallback sendCallback, int timesTotal, AtomicInteger curTimes, Exception e, boolean needRetry, ProducerImpl producer) {
        int tmp = curTimes.incrementAndGet();
        if (needRetry && tmp <= timesTotal) {
            logger.info("async send msg by retry {} times", (Object)tmp);
            Cmq.CMQProto newRequest = Cmq.CMQProto.newBuilder(request).setSeqno(RequestIdHelper.getNextSeqNo()).build();
            try {
                if (tmp == 1) {
                    accessList = producer.findQueueRoute(request.getTcpSendMsg().getQueueName(), true);
                }
                this.sendMessageAsync(accessList, timeoutMillis, newRequest, sendCallback, timesTotal, curTimes, producer);
            }
            catch (InterruptedException e1) {
                this.onExceptionImpl(accessList, timeoutMillis, newRequest, sendCallback, timesTotal, curTimes, (Exception)e1, false, producer);
            }
            catch (RemoteTooMuchRequestException e1) {
                this.onExceptionImpl(accessList, timeoutMillis, newRequest, sendCallback, timesTotal, curTimes, (Exception)e1, false, producer);
            }
            catch (MQClientException e1) {
                this.onExceptionImpl(accessList, timeoutMillis, newRequest, sendCallback, timesTotal, curTimes, (Exception)e1, false, producer);
            }
            catch (MQServerException e1) {
                this.onExceptionImpl(accessList, timeoutMillis, newRequest, sendCallback, timesTotal, curTimes, (Exception)e1, true, producer);
            }
            catch (RemoteException e1) {
                this.onExceptionImpl(accessList, timeoutMillis, newRequest, sendCallback, timesTotal, curTimes, (Exception)e1, true, producer);
            }
        } else {
            try {
                sendCallback.onException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private SendResult processSendResponse(Cmq.CMQProto response) {
        long msgId = -1L;
        if (response.getMsgidsCount() > 0) {
            msgId = response.getMsgids(0);
        }
        return new SendResult(response.getResult(), msgId, response.getSeqno(), response.getError());
    }

    public BatchSendResult batchSendMessage(List<String> accessList, Cmq.CMQProto request, long timeoutMillis, CommunicationMode communicationMode, BatchSendCallback sendCallback, int retryTimesWhenSendFailed, ProducerImpl producer) throws RemoteException, InterruptedException {
        switch (communicationMode) {
            case SYNC: {
                return this.batchSendMessageSync(accessList, request, timeoutMillis);
            }
            case ASYNC: {
                AtomicInteger times = new AtomicInteger();
                this.batchSendMessageAsync(accessList, timeoutMillis, request, sendCallback, retryTimesWhenSendFailed, times, producer);
                return null;
            }
            case ONEWAY: {
                this.nettyClient.invokeOneWay(accessList, request, timeoutMillis);
                return null;
            }
        }
        assert (false);
        return null;
    }

    private BatchSendResult batchSendMessageSync(List<String> addressList, Cmq.CMQProto request, long timeoutMillis) throws RemoteException, InterruptedException {
        Cmq.CMQProto response = this.nettyClient.invokeSync(addressList, request, timeoutMillis);
        assert (response != null);
        return new BatchSendResult(response.getResult(), response.getSeqno(), response.getError(), response.getMsgidsList());
    }

    private void batchSendMessageAsync(final List<String> accessList, final long timeoutMillis, final Cmq.CMQProto request, final BatchSendCallback batchSendCallback, final int retryTimesWhenSendFailed, final AtomicInteger times, final ProducerImpl producer) throws InterruptedException, RemoteException {
        this.nettyClient.invokeAsync(accessList, request, timeoutMillis, new InvokeCallback(){

            @Override
            public void operationComplete(ResponseFuture responseFuture) {
                Cmq.CMQProto response = responseFuture.getResponseCommand();
                if (response != null) {
                    BatchSendResult sendResult = new BatchSendResult(response.getResult(), response.getSeqno(), response.getError(), response.getMsgidsList());
                    if (batchSendCallback != null) {
                        try {
                            batchSendCallback.onSuccess(sendResult);
                        }
                        catch (Throwable throwable) {}
                    }
                } else {
                    MQClientException ex = new MQClientException(responseFuture.getErrorMsg("batchSendMessageAsync"), responseFuture.getCause());
                    CMQClient.this.onExceptionImpl((List<String>)accessList, timeoutMillis, request, batchSendCallback, retryTimesWhenSendFailed, times, ex, true, producer);
                }
            }
        });
    }

    private void onExceptionImpl(List<String> accessList, long timeoutMillis, Cmq.CMQProto request, BatchSendCallback sendCallback, int timesTotal, AtomicInteger curTimes, Exception e, boolean needRetry, ProducerImpl producer) {
        int tmp = curTimes.incrementAndGet();
        if (needRetry && tmp <= timesTotal) {
            logger.info("async send msg by retry {} times", (Object)tmp);
            Cmq.CMQProto newRequest = Cmq.CMQProto.newBuilder(request).setSeqno(RequestIdHelper.getNextSeqNo()).build();
            try {
                if (tmp == 1) {
                    accessList = producer.findQueueRoute(request.getTcpBatchSendMsg().getQueueName(), true);
                }
                this.batchSendMessageAsync(accessList, timeoutMillis, newRequest, sendCallback, timesTotal, curTimes, producer);
            }
            catch (MQClientException e1) {
                this.onExceptionImpl(accessList, timeoutMillis, newRequest, sendCallback, timesTotal, curTimes, (Exception)e1, false, producer);
            }
            catch (InterruptedException e1) {
                this.onExceptionImpl(accessList, timeoutMillis, newRequest, sendCallback, timesTotal, curTimes, (Exception)e1, false, producer);
            }
            catch (RemoteTooMuchRequestException e1) {
                this.onExceptionImpl(accessList, timeoutMillis, newRequest, sendCallback, timesTotal, curTimes, (Exception)e1, false, producer);
            }
            catch (MQServerException e1) {
                this.onExceptionImpl(accessList, timeoutMillis, newRequest, sendCallback, timesTotal, curTimes, (Exception)e1, true, producer);
            }
            catch (RemoteException e1) {
                this.onExceptionImpl(accessList, timeoutMillis, newRequest, sendCallback, timesTotal, curTimes, (Exception)e1, true, producer);
            }
        } else {
            try {
                sendCallback.onException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public PublishResult publishMessage(List<String> accessList, Cmq.CMQProto request, long timeoutMillis, CommunicationMode communicationMode, PublishCallback publishCallback, int retryTimesWhenSendFailed, ProducerImpl producer) throws RemoteException, InterruptedException {
        switch (communicationMode) {
            case SYNC: {
                return this.publishMessageSync(accessList, request, timeoutMillis);
            }
            case ASYNC: {
                AtomicInteger times = new AtomicInteger();
                this.publishMessageAsync(accessList, timeoutMillis, request, publishCallback, retryTimesWhenSendFailed, times, producer);
                return null;
            }
            case ONEWAY: {
                this.nettyClient.invokeOneWay(accessList, request, timeoutMillis);
                return null;
            }
        }
        assert (false);
        return null;
    }

    private PublishResult publishMessageSync(List<String> addressList, Cmq.CMQProto request, long timeoutMillis) throws RemoteException, InterruptedException {
        Cmq.CMQProto response = this.nettyClient.invokeSync(addressList, request, timeoutMillis);
        assert (response != null);
        return this.processPublishResponse(response);
    }

    private void publishMessageAsync(final List<String> accessList, final long timeoutMillis, final Cmq.CMQProto request, final PublishCallback publishCallback, final int retryTimesWhenSendFailed, final AtomicInteger times, final ProducerImpl producer) throws InterruptedException, RemoteException {
        this.nettyClient.invokeAsync(accessList, request, timeoutMillis, new InvokeCallback(){

            @Override
            public void operationComplete(ResponseFuture responseFuture) {
                Cmq.CMQProto response = responseFuture.getResponseCommand();
                if (response != null) {
                    PublishResult publishResult = CMQClient.this.processPublishResponse(response);
                    if (publishCallback != null) {
                        try {
                            publishCallback.onSuccess(publishResult);
                        }
                        catch (Throwable throwable) {}
                    }
                } else {
                    MQClientException ex = new MQClientException(responseFuture.getErrorMsg("publishMessageAsync"), responseFuture.getCause());
                    CMQClient.this.onExceptionImpl((List<String>)accessList, timeoutMillis, request, publishCallback, retryTimesWhenSendFailed, times, ex, true, producer);
                }
            }
        });
    }

    private void onExceptionImpl(List<String> accessList, long timeoutMillis, Cmq.CMQProto request, PublishCallback publishCallback, int timesTotal, AtomicInteger curTimes, Exception e, boolean needRetry, ProducerImpl producer) {
        int tmp = curTimes.incrementAndGet();
        if (needRetry && tmp <= timesTotal) {
            logger.info("async send msg by retry {} times", (Object)tmp);
            Cmq.CMQProto newRequest = Cmq.CMQProto.newBuilder(request).setSeqno(RequestIdHelper.getNextSeqNo()).build();
            try {
                if (tmp == 1) {
                    accessList = producer.findTopicRoute(request.getTcpPublishMsg().getTopicName(), true);
                }
                this.publishMessageAsync(accessList, timeoutMillis, newRequest, publishCallback, timesTotal, curTimes, producer);
            }
            catch (MQClientException e1) {
                this.onExceptionImpl(accessList, timeoutMillis, newRequest, publishCallback, timesTotal, curTimes, (Exception)e1, false, producer);
            }
            catch (InterruptedException e1) {
                this.onExceptionImpl(accessList, timeoutMillis, newRequest, publishCallback, timesTotal, curTimes, (Exception)e1, false, producer);
            }
            catch (RemoteTooMuchRequestException e1) {
                this.onExceptionImpl(accessList, timeoutMillis, newRequest, publishCallback, timesTotal, curTimes, (Exception)e1, false, producer);
            }
            catch (MQServerException e1) {
                this.onExceptionImpl(accessList, timeoutMillis, newRequest, publishCallback, timesTotal, curTimes, (Exception)e1, true, producer);
            }
            catch (RemoteException e1) {
                this.onExceptionImpl(accessList, timeoutMillis, newRequest, publishCallback, timesTotal, curTimes, (Exception)e1, true, producer);
            }
        } else {
            try {
                publishCallback.onException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private PublishResult processPublishResponse(Cmq.CMQProto response) {
        long msgId = -1L;
        if (response.getMsgidsCount() > 0) {
            msgId = response.getMsgids(0);
        }
        return new PublishResult(response.getResult(), msgId, response.getSeqno(), response.getError());
    }

    public BatchPublishResult batchPublishMessage(List<String> accessList, Cmq.CMQProto request, long timeoutMillis, CommunicationMode communicationMode, BatchPublishCallback publishCallback, int retryTimesWhenSendFailed, ProducerImpl producer) throws RemoteException, InterruptedException {
        switch (communicationMode) {
            case SYNC: {
                return this.batchPublishMessageSync(accessList, request, timeoutMillis);
            }
            case ASYNC: {
                AtomicInteger times = new AtomicInteger();
                this.batchPublishMessageAsync(accessList, timeoutMillis, request, publishCallback, retryTimesWhenSendFailed, times, producer);
                return null;
            }
            case ONEWAY: {
                this.nettyClient.invokeOneWay(accessList, request, timeoutMillis);
                return null;
            }
        }
        assert (false);
        return null;
    }

    private BatchPublishResult batchPublishMessageSync(List<String> addressList, Cmq.CMQProto request, long timeoutMillis) throws RemoteException, InterruptedException {
        Cmq.CMQProto response = this.nettyClient.invokeSync(addressList, request, timeoutMillis);
        assert (response != null);
        return new BatchPublishResult(response.getResult(), response.getSeqno(), response.getError(), response.getMsgidsList());
    }

    private void batchPublishMessageAsync(final List<String> accessList, final long timeoutMillis, final Cmq.CMQProto request, final BatchPublishCallback publishCallback, final int retryTimesWhenSendFailed, final AtomicInteger times, final ProducerImpl producer) throws InterruptedException, RemoteException {
        this.nettyClient.invokeAsync(accessList, request, timeoutMillis, new InvokeCallback(){

            @Override
            public void operationComplete(ResponseFuture responseFuture) {
                Cmq.CMQProto response = responseFuture.getResponseCommand();
                if (response != null) {
                    BatchPublishResult sendResult = new BatchPublishResult(response.getResult(), response.getSeqno(), response.getError(), response.getMsgidsList());
                    if (publishCallback != null) {
                        try {
                            publishCallback.onSuccess(sendResult);
                        }
                        catch (Throwable throwable) {}
                    }
                } else {
                    MQClientException ex = new MQClientException(responseFuture.getErrorMsg("batchPublishMessageAsync"), responseFuture.getCause());
                    CMQClient.this.onExceptionImpl((List<String>)accessList, timeoutMillis, request, publishCallback, retryTimesWhenSendFailed, times, ex, true, producer);
                }
            }
        });
    }

    private void onExceptionImpl(List<String> accessList, long timeoutMillis, Cmq.CMQProto request, BatchPublishCallback publishCallback, int timesTotal, AtomicInteger curTimes, Exception e, boolean needRetry, ProducerImpl producer) {
        int tmp = curTimes.incrementAndGet();
        if (needRetry && tmp <= timesTotal) {
            logger.info("async send msg by retry {} times", (Object)tmp);
            Cmq.CMQProto newRequest = Cmq.CMQProto.newBuilder(request).setSeqno(RequestIdHelper.getNextSeqNo()).build();
            try {
                if (tmp == 1) {
                    accessList = producer.findTopicRoute(request.getTcpBatchPublishMsg().getTopicName(), true);
                }
                this.batchPublishMessageAsync(accessList, timeoutMillis, newRequest, publishCallback, timesTotal, curTimes, producer);
            }
            catch (MQClientException e1) {
                this.onExceptionImpl(accessList, timeoutMillis, newRequest, publishCallback, timesTotal, curTimes, (Exception)e1, false, producer);
            }
            catch (InterruptedException e1) {
                this.onExceptionImpl(accessList, timeoutMillis, newRequest, publishCallback, timesTotal, curTimes, (Exception)e1, false, producer);
            }
            catch (RemoteTooMuchRequestException e1) {
                this.onExceptionImpl(accessList, timeoutMillis, newRequest, publishCallback, timesTotal, curTimes, (Exception)e1, false, producer);
            }
            catch (MQServerException e1) {
                this.onExceptionImpl(accessList, timeoutMillis, newRequest, publishCallback, timesTotal, curTimes, (Exception)e1, true, producer);
            }
            catch (RemoteException e1) {
                this.onExceptionImpl(accessList, timeoutMillis, newRequest, publishCallback, timesTotal, curTimes, (Exception)e1, true, producer);
            }
        } else {
            try {
                publishCallback.onException(e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public ReceiveResult receiveMessage(List<String> accessList, Cmq.CMQProto request, long timeoutMillis, CommunicationMode communicationMode, ReceiveCallback pullCallback) throws RemoteException, InterruptedException {
        switch (communicationMode) {
            case ONEWAY: {
                assert (false);
                return null;
            }
            case ASYNC: {
                this.receiveMessageAsync(accessList, request, timeoutMillis, pullCallback);
                return null;
            }
            case SYNC: {
                return this.receiveMessageSync(accessList, request, timeoutMillis);
            }
        }
        assert (false);
        return null;
    }

    private void receiveMessageAsync(final List<String> accessList, final Cmq.CMQProto request, long timeoutMillis, final ReceiveCallback pullCallback) throws RemoteException, InterruptedException {
        this.nettyClient.invokeAsync(accessList, request, timeoutMillis, new InvokeCallback(){

            @Override
            public void operationComplete(ResponseFuture responseFuture) {
                Cmq.CMQProto response = responseFuture.getResponseCommand();
                if (response != null) {
                    try {
                        ReceiveResult receiveResult = CMQClient.this.processReceiveResponse(response);
                        pullCallback.onSuccess(receiveResult);
                    }
                    catch (Exception e) {
                        pullCallback.onException(e);
                    }
                } else {
                    String prefix = String.format("receiveMessageAsync:Server[%s], request[%s]", accessList, TextFormat.shortDebugString((Message)request));
                    pullCallback.onException(new MQClientException(responseFuture.getErrorMsg(prefix), responseFuture.getCause()));
                }
            }
        });
    }

    private ReceiveResult receiveMessageSync(List<String> accessList, Cmq.CMQProto request, long timeoutMillis) throws RemoteException, InterruptedException {
        Cmq.CMQProto response = this.nettyClient.invokeSync(accessList, request, timeoutMillis);
        assert (response != null);
        return this.processReceiveResponse(response);
    }

    private ReceiveResult processReceiveResponse(Cmq.CMQProto response) {
        Cmq.cmq_pull_msg_rsp responseContent = response.getPullRsp();
        com.qcloud.cmq.client.consumer.Message message = new com.qcloud.cmq.client.consumer.Message(responseContent.getMsgId(), responseContent.getReceiptHandle(), responseContent.getMsgBody().toStringUtf8());
        return new ReceiveResult(response.getResult(), response.getSeqno(), response.getError(), message);
    }

    public BatchReceiveResult batchReceiveMessage(List<String> accessList, Cmq.CMQProto request, long timeoutMillis, CommunicationMode communicationMode, BatchReceiveCallback pullCallback) throws RemoteException, InterruptedException {
        switch (communicationMode) {
            case ONEWAY: {
                assert (false);
                return null;
            }
            case ASYNC: {
                this.batchReceiveMessageAsync(accessList, request, timeoutMillis, pullCallback);
                return null;
            }
            case SYNC: {
                return this.batchReceiveMessageSync(accessList, request, timeoutMillis);
            }
        }
        assert (false);
        return null;
    }

    private void batchReceiveMessageAsync(final List<String> accessList, final Cmq.CMQProto request, long timeoutMillis, final BatchReceiveCallback pullCallback) throws RemoteException, InterruptedException {
        this.nettyClient.invokeAsync(accessList, request, timeoutMillis, new InvokeCallback(){

            @Override
            public void operationComplete(ResponseFuture responseFuture) {
                Cmq.CMQProto response = responseFuture.getResponseCommand();
                if (response != null) {
                    try {
                        BatchReceiveResult receiveResult = CMQClient.this.processBatchReceiveResponse(response);
                        pullCallback.onSuccess(receiveResult);
                    }
                    catch (Exception e) {
                        pullCallback.onException(e);
                    }
                } else {
                    String prefix = String.format("batchReceiveMessageAsync:Server[%s], request[%s]", accessList, TextFormat.shortDebugString((Message)request));
                    pullCallback.onException(new MQClientException(responseFuture.getErrorMsg(prefix), responseFuture.getCause()));
                }
            }
        });
    }

    private BatchReceiveResult batchReceiveMessageSync(List<String> accessList, Cmq.CMQProto request, long timeoutMillis) throws RemoteException, InterruptedException {
        Cmq.CMQProto response = this.nettyClient.invokeSync(accessList, request, timeoutMillis);
        assert (response != null);
        return this.processBatchReceiveResponse(response);
    }

    private BatchReceiveResult processBatchReceiveResponse(Cmq.CMQProto response) {
        Cmq.cmq_batch_pull_msg_rsp responseContent = response.getBatchPullRsp();
        ArrayList<com.qcloud.cmq.client.consumer.Message> messageList = new ArrayList<com.qcloud.cmq.client.consumer.Message>();
        for (Cmq.cmq_pull_msg_rsp rsp : responseContent.getMsgListList()) {
            messageList.add(new com.qcloud.cmq.client.consumer.Message(rsp.getMsgId(), rsp.getReceiptHandle(), rsp.getMsgBody().toStringUtf8()));
        }
        return new BatchReceiveResult(response.getResult(), response.getSeqno(), response.getError(), messageList);
    }

    public DeleteResult deleteMessage(List<String> accessList, Cmq.CMQProto request, long timeoutMillis, CommunicationMode communicationMode, DeleteCallback pullCallback) throws RemoteException, InterruptedException {
        switch (communicationMode) {
            case ONEWAY: {
                assert (false);
                return null;
            }
            case ASYNC: {
                this.deleteMessageAsync(accessList, request, timeoutMillis, pullCallback);
                return null;
            }
            case SYNC: {
                return this.deleteMessageSync(accessList, request, timeoutMillis);
            }
        }
        assert (false);
        return null;
    }

    private void deleteMessageAsync(final List<String> accessList, final Cmq.CMQProto request, long timeoutMillis, final DeleteCallback callback) throws RemoteException, InterruptedException {
        this.nettyClient.invokeAsync(accessList, request, timeoutMillis, new InvokeCallback(){

            @Override
            public void operationComplete(ResponseFuture responseFuture) {
                Cmq.CMQProto response = responseFuture.getResponseCommand();
                if (response != null) {
                    try {
                        DeleteResult deleteResult = new DeleteResult(response.getResult(), response.getSeqno(), response.getError());
                        callback.onSuccess(deleteResult);
                    }
                    catch (Exception e) {
                        callback.onException(e);
                    }
                } else {
                    String prefix = String.format("deleteMessageAsync:Server[%s], request[%s]", accessList, TextFormat.shortDebugString((Message)request));
                    callback.onException(new MQClientException(responseFuture.getErrorMsg(prefix), responseFuture.getCause()));
                }
            }
        });
    }

    private DeleteResult deleteMessageSync(List<String> accessList, Cmq.CMQProto request, long timeoutMillis) throws RemoteException, InterruptedException {
        Cmq.CMQProto response = this.nettyClient.invokeSync(accessList, request, timeoutMillis);
        assert (response != null);
        return new DeleteResult(response.getResult(), response.getSeqno(), response.getError());
    }

    public BatchDeleteResult batchDeleteMessage(List<String> accessList, Cmq.CMQProto request, long timeoutMillis, CommunicationMode communicationMode, BatchDeleteCallback callback) throws RemoteException, InterruptedException {
        switch (communicationMode) {
            case ONEWAY: {
                assert (false);
                return null;
            }
            case ASYNC: {
                this.batchDeleteMessageAsync(accessList, request, timeoutMillis, callback);
                return null;
            }
            case SYNC: {
                return this.batchDeleteMessageSync(accessList, request, timeoutMillis);
            }
        }
        assert (false);
        return null;
    }

    private void batchDeleteMessageAsync(final List<String> accessList, final Cmq.CMQProto request, long timeoutMillis, final BatchDeleteCallback callback) throws RemoteException, InterruptedException {
        this.nettyClient.invokeAsync(accessList, request, timeoutMillis, new InvokeCallback(){

            @Override
            public void operationComplete(ResponseFuture responseFuture) {
                Cmq.CMQProto response = responseFuture.getResponseCommand();
                if (response != null) {
                    try {
                        BatchDeleteResult deleteResult = CMQClient.this.processBatchDeleteResponse(response);
                        callback.onSuccess(deleteResult);
                    }
                    catch (Exception e) {
                        callback.onException(e);
                    }
                } else {
                    String prefix = String.format("batchDeleteMessageAsync:Server[%s], request[%s]", accessList, TextFormat.shortDebugString((Message)request));
                    callback.onException(new MQClientException(responseFuture.getErrorMsg(prefix), responseFuture.getCause()));
                }
            }
        });
    }

    private BatchDeleteResult batchDeleteMessageSync(List<String> accessList, Cmq.CMQProto request, long timeoutMillis) throws RemoteException, InterruptedException {
        Cmq.CMQProto response = this.nettyClient.invokeSync(accessList, request, timeoutMillis);
        assert (response != null);
        return this.processBatchDeleteResponse(response);
    }

    private BatchDeleteResult processBatchDeleteResponse(Cmq.CMQProto response) {
        List<Cmq.cmq_msg_delete_result> responseContent = response.getDelResultList();
        ArrayList<ReceiptHandleErrorInfo> errorInfoList = new ArrayList<ReceiptHandleErrorInfo>();
        for (Cmq.cmq_msg_delete_result rsp : responseContent) {
            errorInfoList.add(new ReceiptHandleErrorInfo(rsp.getErrCode(), rsp.getErrMsg(), rsp.getReceiptHandle()));
        }
        return new BatchDeleteResult(response.getResult(), response.getSeqno(), response.getError(), errorInfoList);
    }
}

