/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cmq.client.client;

import com.qcloud.cmq.client.client.CMQClient;
import com.qcloud.cmq.client.client.CMQClientHandler;
import com.qcloud.cmq.client.client.MQClientManager;
import com.qcloud.cmq.client.client.NameServerClient;
import com.qcloud.cmq.client.common.ClientConfig;
import com.qcloud.cmq.client.common.LogHelper;
import com.qcloud.cmq.client.common.NettyClientConfig;
import com.qcloud.cmq.client.common.ServiceState;
import com.qcloud.cmq.client.consumer.ConsumerImpl;
import com.qcloud.cmq.client.exception.MQClientException;
import com.qcloud.cmq.client.exception.MQServerException;
import com.qcloud.cmq.client.producer.ProducerImpl;
import io.netty.util.internal.ConcurrentSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;

public class MQClientInstance {
    private static final long LOCK_TIMEOUT_MILLIS = 3000L;
    private final Logger logger = LogHelper.getLog();
    private final ClientConfig clientConfig;
    private final String clientId;
    private final ConcurrentSet<ProducerImpl> producerTable = new ConcurrentSet();
    private final ConcurrentSet<ConsumerImpl> consumerTable = new ConcurrentSet();
    private final ConcurrentHashMap<String, NameServerClient> nameServerTable = new ConcurrentHashMap();
    private final Lock lockNameServer = new ReentrantLock();
    private final CMQClient cMQClient;
    private ServiceState serviceState = ServiceState.CREATE_JUST;

    MQClientInstance(ClientConfig clientConfig, int instanceIndex, String clientId) {
        this.clientConfig = clientConfig;
        this.clientId = clientId;
        NettyClientConfig nettyClientConfig = new NettyClientConfig();
        nettyClientConfig.setClientCallbackExecutorThreads(clientConfig.getClientCallbackExecutorThreads());
        nettyClientConfig.setConnectTimeoutMillis(clientConfig.getRequestTimeoutMS());
        CMQClientHandler cMQClientHandler = new CMQClientHandler(this);
        this.cMQClient = new CMQClient(nettyClientConfig, cMQClientHandler, clientConfig, clientId);
        this.logger.info("created a new client Instance, FactoryIndex: {} ClientID: {} {} ", new Object[]{instanceIndex, this.clientId, this.clientConfig});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws MQClientException {
        MQClientInstance mQClientInstance = this;
        synchronized (mQClientInstance) {
            switch (this.serviceState) {
                case CREATE_JUST: {
                    this.serviceState = ServiceState.START_FAILED;
                    this.checkConfig();
                    this.initNameServerClient();
                    this.cMQClient.start();
                    this.serviceState = ServiceState.RUNNING;
                    break;
                }
                case RUNNING: {
                    break;
                }
                case SHUTDOWN_ALREADY: {
                    break;
                }
                case START_FAILED: {
                    throw new MQClientException(1, "The client instance object[" + this.clientId + "] has been created before, and failed.");
                }
            }
        }
    }

    private void checkConfig() throws MQClientException {
        if (null == this.clientConfig.getNameServerAddress()) {
            throw new MQClientException("NameServer address is null", null);
        }
        if (null == this.clientConfig.getSecretId()) {
            throw new MQClientException("SecretID is null", null);
        }
        if (null == this.clientConfig.getSecretKey()) {
            throw new MQClientException("SecretKey is null", null);
        }
        if (null == this.clientConfig.getSignMethod()) {
            this.clientConfig.setSignMethod("HmacSHA1");
        } else if (!this.clientConfig.getSignMethod().equals("HmacSHA1") && !this.clientConfig.getSignMethod().equals("HmacSHA256")) {
            throw new MQClientException(221, "SignatureMethod must be HmacSHA1 or HmacSHA256");
        }
    }

    private void initNameServerClient() {
        String addressList = this.clientConfig.getNameServerAddress();
        String[] addressArray = addressList.split(";");
        List<String> list = Arrays.asList(addressArray);
        Collections.shuffle(list);
        for (String address : list) {
            this.logger.info("create a new name server client, address: {} ", (Object)address);
            this.nameServerTable.put(address, new NameServerClient(address, this.clientConfig));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (!this.consumerTable.isEmpty() || !this.producerTable.isEmpty()) {
            return;
        }
        MQClientInstance mQClientInstance = this;
        synchronized (mQClientInstance) {
            switch (this.serviceState) {
                case CREATE_JUST: {
                    break;
                }
                case RUNNING: {
                    this.serviceState = ServiceState.SHUTDOWN_ALREADY;
                    this.cMQClient.shutdown();
                    MQClientManager.getInstance().removeClientFactory(this.clientId);
                    this.logger.info("the client instance [{}] shutdown OK", (Object)this.clientId);
                    break;
                }
                case SHUTDOWN_ALREADY: {
                    break;
                }
            }
        }
    }

    public void updateQueueRoute(String queue, ConcurrentHashMap<String, List<String>> routeTable) throws MQClientException {
        try {
            if (this.lockNameServer.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                for (NameServerClient client : this.nameServerTable.values()) {
                    try {
                        List<String> result = client.fetchQueueRoute(queue);
                        routeTable.put(queue, result);
                        break;
                    }
                    catch (MQServerException e) {
                        this.logger.error("updateQueueRoute with Exception", (Throwable)e);
                    }
                }
                this.lockNameServer.unlock();
            } else {
                this.logger.warn("updateQueueRoute tryLock timeout {}ms", (Object)3000L);
            }
        }
        catch (InterruptedException e) {
            this.logger.warn("updateQueueRoute Exception", (Throwable)e);
        }
    }

    public void updateTopicRoute(String topic, ConcurrentHashMap<String, List<String>> routeTable) throws MQClientException {
        try {
            if (this.lockNameServer.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                for (NameServerClient client : this.nameServerTable.values()) {
                    try {
                        List<String> result = client.fetchTopicRoute(topic);
                        routeTable.put(topic, result);
                        break;
                    }
                    catch (MQServerException e) {
                        this.logger.error("updateTopicRoute with Exception", (Throwable)e);
                    }
                }
                this.lockNameServer.unlock();
            } else {
                this.logger.warn("updateTopicRoute tryLock timeout {}ms", (Object)3000L);
            }
        }
        catch (InterruptedException e) {
            this.logger.warn("updateTopicRoute Exception", (Throwable)e);
        }
    }

    public void registerConsumer(ConsumerImpl consumer) {
        if (consumer != null) {
            this.consumerTable.add((Object)consumer);
        }
    }

    public void unRegisterConsumer(ConsumerImpl consumer) {
        this.consumerTable.remove((Object)consumer);
    }

    public void registerProducer(ProducerImpl producer) {
        if (producer != null) {
            this.producerTable.add((Object)producer);
        }
    }

    public void unRegisterProducer(ProducerImpl producer) {
        this.producerTable.remove((Object)producer);
    }

    public CMQClient getCMQClient() {
        return this.cMQClient;
    }
}

