/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cmq.client.cloudapi;

import com.qcloud.cmq.client.client.CloudApiQueueClientV2;
import com.qcloud.cmq.client.client.CloudApiTopicClientV2;
import com.qcloud.cmq.client.cloudapi.CloudApiQueueClient;
import com.qcloud.cmq.client.cloudapi.CloudApiTopicClient;
import com.qcloud.cmq.client.cloudapi.QueueMeta;
import com.qcloud.cmq.client.cloudapi.SubscribeConfig;
import com.qcloud.cmq.client.cloudapi.entity.CmqQueue;
import com.qcloud.cmq.client.common.AssertUtil;
import com.qcloud.cmq.client.common.CloudApiClientConfig;
import com.qcloud.cmq.client.exception.MQClientException;
import com.qcloud.cmq.client.http.CloudApiHttpClient;
import java.util.List;

public class CloudApiManager
extends CloudApiClientConfig {
    private volatile CloudApiQueueClient cloudApiQueueClient;
    private volatile CloudApiTopicClient cloudApiTopicClient;

    public void start() throws MQClientException {
        this.initClient();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initClient() {
        if (this.cloudApiTopicClient == null || this.cloudApiQueueClient == null) {
            CloudApiManager cloudApiManager = this;
            synchronized (cloudApiManager) {
                if (this.cloudApiTopicClient == null || this.cloudApiQueueClient == null) {
                    CloudApiHttpClient cloudApiHttpClient = new CloudApiHttpClient(this);
                    this.cloudApiTopicClient = new CloudApiTopicClientV2(cloudApiHttpClient);
                    this.cloudApiQueueClient = new CloudApiQueueClientV2(cloudApiHttpClient);
                }
            }
        }
    }

    public String createQueue(String queueName) {
        return this.cloudApiQueueClient.createQueue(queueName, new QueueMeta());
    }

    public String createQueue(String queueName, QueueMeta queueMeta) {
        AssertUtil.assertParamNotNull(queueMeta, "QueueMeta is null");
        return this.cloudApiQueueClient.createQueue(queueName, queueMeta);
    }

    public int countQueue(String searchWord, int offset, int limit) {
        return this.cloudApiQueueClient.countQueue(searchWord, offset, limit);
    }

    public List<CmqQueue> describeQueue(String searchWord, int offset, int limit) {
        return this.cloudApiQueueClient.describeQueue(searchWord, offset, limit);
    }

    public String createQueueAndSubscribe(String queueName, String topicName, String subscribeName) {
        return this.createQueueAndSubscribe(queueName, new QueueMeta(), topicName, subscribeName);
    }

    public String createSubscribe(SubscribeConfig subscribeConfig) {
        return this.cloudApiTopicClient.createSubscribe(subscribeConfig);
    }

    public void deleteSubscribe(String topicName, String subscriptionName) {
        this.cloudApiTopicClient.deleteSubscribe(topicName, subscriptionName);
    }

    public String createQueueAndSubscribe(String queueName, QueueMeta queueMeta, String topicName, String subscribeName) {
        String queueId = this.cloudApiQueueClient.createQueue(queueName, queueMeta);
        SubscribeConfig subscribeConfig = new SubscribeConfig();
        subscribeConfig.setTopicName(topicName);
        subscribeConfig.setProtocol("queue");
        subscribeConfig.setSubscriptionName(subscribeName);
        subscribeConfig.setEndpoint(queueName);
        this.cloudApiTopicClient.createSubscribe(subscribeConfig);
        return queueId;
    }

    public QueueMeta describeQueueAttributes(String queueName) {
        return this.cloudApiQueueClient.getQueueAttributes(queueName);
    }

    public void deleteQueue(String queueName) {
        this.cloudApiQueueClient.deleteQueue(queueName);
    }
}

