/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cmq.client.common;

import com.qcloud.cmq.client.common.RemoteHelper;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

public class ClientConfig {
    private static final String NAMESRV_ADDR_ENV = "NAMESRV_ADDR";
    private static final String NAMESRV_ADDR_PROPERTY = "cmq.namesrv.addr";
    private static final String CLIENT_NAME_PROPERTY = "cmq.client.name";
    private static final String CMQ_SECRET_ID_ENV = "CMQ_SECRET_ID";
    private static final String CMQ_SECRET_ID_PROPERTY = "cmq.client.secretId";
    private static final String CMQ_SECRET_KEY_ENV = "CMQ_SECRET_KEY";
    private static final String CMQ_SECRET_KEY_PROPERTY = "cmq.client.secretKey";
    private static final String CMQ_SIGN_METHOD_ENV = "CMQ_SIGN_METHOD";
    private static final String CMQ_SIGN_METHOD_PROPERTY = "cmq.client.signMethod";
    public static final String SIGN_METHOD_SHA1 = "HmacSHA1";
    public static final String SIGN_METHOD_SHA256 = "HmacSHA256";
    private String nameServerAddress = System.getProperty("cmq.namesrv.addr", System.getenv("NAMESRV_ADDR"));
    private String clientIP = RemoteHelper.getLocalAddress();
    private String instanceName = System.getProperty("cmq.client.name", "DEFAULT");
    private int clientCallbackExecutorThreads = Runtime.getRuntime().availableProcessors();
    private String secretId = System.getProperty("cmq.client.secretId", System.getenv("CMQ_SECRET_ID"));
    private String secretKey = System.getProperty("cmq.client.secretKey", System.getenv("CMQ_SECRET_KEY"));
    private String signMethod = System.getProperty("cmq.client.signMethod", System.getenv("CMQ_SIGN_METHOD"));
    private int requestTimeoutMS = 3000;
    private int retryTimesWhenSendFailed = 2;
    private int pollingWaitSeconds = 10;
    private int batchPullNumber = 16;

    public String buildMQClientId() {
        return this.getClientIP() + "@" + this.getInstanceName();
    }

    public ClientConfig cloneClientConfig() {
        ClientConfig cc = new ClientConfig();
        cc.nameServerAddress = this.nameServerAddress;
        cc.clientIP = this.clientIP;
        cc.instanceName = this.instanceName;
        cc.clientCallbackExecutorThreads = this.clientCallbackExecutorThreads;
        cc.secretId = this.secretId;
        cc.secretKey = this.secretKey;
        cc.signMethod = this.signMethod;
        cc.requestTimeoutMS = this.requestTimeoutMS;
        cc.retryTimesWhenSendFailed = this.retryTimesWhenSendFailed;
        cc.pollingWaitSeconds = this.pollingWaitSeconds;
        cc.batchPullNumber = this.batchPullNumber;
        return cc;
    }

    public void changeInstanceNameToPID() {
        this.instanceName = String.valueOf(ClientConfig.getPid());
    }

    public String getNameServerAddress() {
        return this.nameServerAddress;
    }

    public void setNameServerAddress(String nameServerAddress) {
        this.nameServerAddress = nameServerAddress;
    }

    public String getClientIP() {
        return this.clientIP;
    }

    public void setClientIP(String clientIP) {
        this.clientIP = clientIP;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public int getClientCallbackExecutorThreads() {
        return this.clientCallbackExecutorThreads;
    }

    public void setClientCallbackExecutorThreads(int clientCallbackExecutorThreads) {
        this.clientCallbackExecutorThreads = clientCallbackExecutorThreads;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public void setSecretId(String secretId) {
        this.secretId = secretId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSignMethod() {
        return this.signMethod;
    }

    public void setSignMethod(String signMethod) {
        this.signMethod = signMethod;
    }

    public int getRequestTimeoutMS() {
        return this.requestTimeoutMS;
    }

    public void setRequestTimeoutMS(int requestTimeoutMS) {
        this.requestTimeoutMS = requestTimeoutMS;
    }

    public int getRetryTimesWhenSendFailed() {
        return this.retryTimesWhenSendFailed;
    }

    public void setRetryTimesWhenSendFailed(int retryTimesWhenSendFailed) {
        this.retryTimesWhenSendFailed = retryTimesWhenSendFailed;
    }

    public int getPollingWaitSeconds() {
        return this.pollingWaitSeconds;
    }

    public void setPollingWaitSeconds(int pollingWaitSeconds) {
        this.pollingWaitSeconds = pollingWaitSeconds;
    }

    public int getBatchPullNumber() {
        return this.batchPullNumber;
    }

    public void setBatchPullNumber(int batchPullNumber) {
        this.batchPullNumber = batchPullNumber;
    }

    public String toString() {
        return "ClientConfig[nameServerAddress=" + this.nameServerAddress + ", clientIP=" + this.clientIP + ", instanceName=" + this.instanceName + ", clientCallbackExecutorThreads=" + this.clientCallbackExecutorThreads + ", secretId=" + this.secretId + ", secretKey=" + this.secretKey + ", signMethod=" + (this.signMethod == null ? SIGN_METHOD_SHA1 : this.signMethod) + ", requestTimeoutMS=" + this.requestTimeoutMS + ", retryTimesWhenSendFailed=" + this.retryTimesWhenSendFailed + ", pollingWaitSeconds=" + this.pollingWaitSeconds + ", batchPullNumber=" + this.batchPullNumber + "]";
    }

    private static int getPid() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String name = runtime.getName();
        try {
            return Integer.parseInt(name.substring(0, name.indexOf(64)));
        }
        catch (Exception e) {
            return -1;
        }
    }
}

