/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cmq.client.common;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;

public class CloudApiClientConfig {
    public static final String DEFAULT_PATH = "/v2/index.php";
    private static final String CLOUD_API_ADDR_PROPERTY = "cmq.cloud.addr";
    private static final String CMQ_SECRET_ID_ENV = "CMQ_SECRET_ID";
    private static final String CMQ_SECRET_ID_PROPERTY = "cmq.client.secretId";
    private static final String CMQ_SECRET_KEY_ENV = "CMQ_SECRET_KEY";
    private static final String CMQ_SECRET_KEY_PROPERTY = "cmq.client.secretKey";
    private static final String CMQ_SIGN_METHOD_ENV = "CMQ_SIGN_METHOD";
    private static final String CMQ_SIGN_METHOD_PROPERTY = "cmq.client.signMethod";
    public static final String SIGN_METHOD_SHA1 = "sha1";
    public static final String SIGN_METHOD_SHA256 = "sha256";
    private String cloudApiAddress = System.getProperty("cmq.cloud.addr", System.getenv("cmq.cloud.addr"));
    private String secretId = System.getProperty("cmq.client.secretId", System.getenv("CMQ_SECRET_ID"));
    private String secretKey = System.getProperty("cmq.client.secretKey", System.getenv("CMQ_SECRET_KEY"));
    private String signMethod = System.getProperty("cmq.client.signMethod", System.getenv("CMQ_SIGN_METHOD"));
    private int requestTimeoutMS = 3000;
    private int connectTimeout = 10000;

    public CloudApiClientConfig cloneClientConfig() {
        CloudApiClientConfig cc = new CloudApiClientConfig();
        cc.secretId = this.secretId;
        cc.secretKey = this.secretKey;
        cc.signMethod = this.signMethod;
        cc.requestTimeoutMS = this.requestTimeoutMS;
        cc.cloudApiAddress = this.cloudApiAddress;
        cc.connectTimeout = this.connectTimeout;
        return cc;
    }

    public String getCloudApiAddress() {
        return this.cloudApiAddress;
    }

    public void setCloudApiAddress(String cloudApiAddress) {
        this.cloudApiAddress = cloudApiAddress;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public void setSecretId(String secretId) {
        this.secretId = secretId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSignMethod() {
        return this.signMethod;
    }

    public void setSignMethod(String signMethod) {
        this.signMethod = signMethod;
    }

    public int getRequestTimeoutMS() {
        return this.requestTimeoutMS;
    }

    public void setRequestTimeoutMS(int requestTimeoutMS) {
        this.requestTimeoutMS = requestTimeoutMS;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public String toString() {
        return "CloudApiClientConfig{cloudApiAddress='" + this.cloudApiAddress + '\'' + ", secretId='" + this.secretId + '\'' + ", secretKey='" + this.secretKey + '\'' + ", signMethod='" + this.signMethod + '\'' + ", requestTimeoutMS=" + this.requestTimeoutMS + ", connectTimeout=" + this.connectTimeout + '}';
    }

    private static int getPid() {
        RuntimeMXBean runtime = ManagementFactory.getRuntimeMXBean();
        String name = runtime.getName();
        try {
            return Integer.parseInt(name.substring(0, name.indexOf(64)));
        }
        catch (Exception e) {
            return -1;
        }
    }
}

