/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cmq.client.common;

import com.qcloud.cmq.client.common.LogHelper;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import org.slf4j.Logger;

public class RemoteHelper {
    private static final Logger logger = LogHelper.getLog();

    public static String exceptionSimpleDesc(Throwable e) {
        StringBuilder sb = new StringBuilder();
        if (e != null) {
            sb.append(e.toString());
            StackTraceElement[] stackTrace = e.getStackTrace();
            if (stackTrace != null && stackTrace.length > 0) {
                StackTraceElement elment = stackTrace[0];
                sb.append(", ");
                sb.append(elment.toString());
            }
        }
        return sb.toString();
    }

    public static SocketAddress string2SocketAddress(String addr) {
        String[] s = addr.split(":");
        InetSocketAddress isa = new InetSocketAddress(s[0], Integer.parseInt(s[1]));
        return isa;
    }

    public static String parseChannelRemoteAddr(Channel channel) {
        String addr;
        if (null == channel) {
            return "";
        }
        SocketAddress remote = channel.remoteAddress();
        String string = addr = remote != null ? remote.toString() : "";
        if (addr.length() > 0) {
            int index = addr.lastIndexOf("/");
            if (index >= 0) {
                return addr.substring(index + 1);
            }
            return addr;
        }
        return "";
    }

    public static String parseSocketAddressAddr(SocketAddress socketAddress) {
        String addr;
        if (socketAddress != null && (addr = socketAddress.toString()).length() > 0) {
            return addr.substring(1);
        }
        return "";
    }

    public static void closeChannel(Channel channel) {
        final String addrRemote = RemoteHelper.parseChannelRemoteAddr(channel);
        channel.close().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                logger.info("closeChannel: close the connection to remote address[{}] result: {}", (Object)addrRemote, (Object)future.isSuccess());
            }
        });
    }

    public static String getLocalAddress() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            ArrayList<String> ipv4Result = new ArrayList<String>();
            ArrayList<String> ipv6Result = new ArrayList<String>();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> en = networkInterface.getInetAddresses();
                while (en.hasMoreElements()) {
                    InetAddress address = en.nextElement();
                    if (address.isLoopbackAddress()) continue;
                    if (address instanceof Inet6Address) {
                        ipv6Result.add(RemoteHelper.normalizeHostAddress(address));
                        continue;
                    }
                    ipv4Result.add(RemoteHelper.normalizeHostAddress(address));
                }
            }
            if (!ipv4Result.isEmpty()) {
                for (String ip : ipv4Result) {
                    if (ip.startsWith("127.0") || ip.startsWith("192.168")) continue;
                    return ip;
                }
                return (String)ipv4Result.get(ipv4Result.size() - 1);
            }
            if (!ipv6Result.isEmpty()) {
                return (String)ipv6Result.get(0);
            }
            InetAddress localHost = InetAddress.getLocalHost();
            return RemoteHelper.normalizeHostAddress(localHost);
        }
        catch (SocketException e) {
            logger.error("get local address error", (Throwable)e);
        }
        catch (UnknownHostException e) {
            logger.error("get local address error", (Throwable)e);
        }
        return null;
    }

    public static String normalizeHostAddress(InetAddress localHost) {
        if (localHost instanceof Inet6Address) {
            return "[" + localHost.getHostAddress() + "]";
        }
        return localHost.getHostAddress();
    }
}

