/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cmq.client.consumer;

import com.qcloud.cmq.client.common.ClientConfig;
import com.qcloud.cmq.client.consumer.BatchDeleteCallback;
import com.qcloud.cmq.client.consumer.BatchDeleteResult;
import com.qcloud.cmq.client.consumer.BatchReceiveCallback;
import com.qcloud.cmq.client.consumer.BatchReceiveResult;
import com.qcloud.cmq.client.consumer.ConsumerImpl;
import com.qcloud.cmq.client.consumer.DeleteCallback;
import com.qcloud.cmq.client.consumer.DeleteResult;
import com.qcloud.cmq.client.consumer.MessageListener;
import com.qcloud.cmq.client.consumer.ReceiveCallback;
import com.qcloud.cmq.client.consumer.ReceiveResult;
import com.qcloud.cmq.client.exception.MQClientException;
import com.qcloud.cmq.client.exception.MQServerException;
import java.util.List;

public class Consumer
extends ClientConfig {
    private ConsumerImpl consumer = new ConsumerImpl(this);

    public void start() throws MQClientException {
        this.consumer.start();
    }

    public ReceiveResult receiveMsg(String queue) throws MQClientException, MQServerException {
        return this.receiveMsg(queue, this.getPollingWaitSeconds());
    }

    public ReceiveResult receiveMsg(String queue, int pollingWaitingSeconds) throws MQClientException, MQServerException {
        return this.consumer.receiveMsg(queue, pollingWaitingSeconds, this.getRequestTimeoutMS());
    }

    public void receiveMsg(String queue, ReceiveCallback callback) throws MQClientException, MQServerException {
        this.receiveMsg(queue, this.getPollingWaitSeconds(), callback);
    }

    public void receiveMsg(String queue, int pollingWaitingSeconds, ReceiveCallback callback) throws MQClientException, MQServerException {
        this.consumer.receiveMsg(queue, pollingWaitingSeconds, this.getRequestTimeoutMS(), callback);
    }

    public BatchReceiveResult batchReceiveMsg(String queue) throws MQClientException, MQServerException {
        return this.batchReceiveMsg(queue, this.getBatchPullNumber());
    }

    public BatchReceiveResult batchReceiveMsg(String queue, int number) throws MQClientException, MQServerException {
        return this.batchReceiveMsg(queue, number, this.getPollingWaitSeconds());
    }

    public BatchReceiveResult batchReceiveMsg(String queue, int number, int pollingWaitSeconds) throws MQClientException, MQServerException {
        return this.consumer.batchReceive(queue, number, pollingWaitSeconds, this.getRequestTimeoutMS());
    }

    public void batchReceiveMsg(String queue, BatchReceiveCallback callback) throws MQClientException, MQServerException {
        this.batchReceiveMsg(queue, this.getBatchPullNumber(), callback);
    }

    public void batchReceiveMsg(String queue, int number, BatchReceiveCallback callback) throws MQClientException, MQServerException {
        this.batchReceiveMsg(queue, number, this.getPollingWaitSeconds(), callback);
    }

    public void batchReceiveMsg(String queue, int number, int pollingWaitSeconds, BatchReceiveCallback callback) throws MQClientException, MQServerException {
        this.consumer.batchReceive(queue, number, pollingWaitSeconds, this.getRequestTimeoutMS(), callback);
    }

    public DeleteResult deleteMsg(String queue, long receiptHandle) throws MQClientException, MQServerException {
        return this.consumer.deleteMsg(queue, receiptHandle, this.getRequestTimeoutMS());
    }

    public void deleteMsg(String queue, long receiptHandle, DeleteCallback callback) throws MQClientException, MQServerException {
        this.consumer.deleteMsg(queue, receiptHandle, this.getRequestTimeoutMS(), callback);
    }

    public BatchDeleteResult batchDeleteMsg(String queue, List<Long> receiptHandleList) throws MQClientException, MQServerException {
        return this.consumer.batchDelete(queue, receiptHandleList, this.getRequestTimeoutMS());
    }

    public void batchDeleteMsg(String queue, List<Long> receiptHandleList, BatchDeleteCallback callback) throws MQClientException, MQServerException {
        this.consumer.batchDelete(queue, receiptHandleList, this.getRequestTimeoutMS(), callback);
    }

    public void subscribe(String queue, MessageListener listener) throws MQClientException, MQServerException {
        this.consumer.subscriber(queue, listener);
    }

    public void unSubscribe(String queue) throws MQClientException {
        this.consumer.unSubscriber(queue);
    }

    public void shutdown() {
        this.consumer.shutdown();
    }
}

