/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cmq.client.http;

import com.qcloud.cmq.client.common.LogHelper;
import com.qcloud.cmq.client.exception.MQClientException;
import com.qcloud.cmq.client.exception.MQServerException;
import com.qcloud.cmq.client.http.HttpWrapper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import java.util.TreeMap;
import org.slf4j.Logger;

public abstract class AbstractHttpWrapper
implements HttpWrapper {
    private final Logger logger = LogHelper.getLog();
    private String endpoint;
    private String path;
    private String secretId;
    private String secretKey;
    private String method;

    public AbstractHttpWrapper(String endpoint, String path, String secretId, String secretKey, String method) {
        this.endpoint = endpoint;
        this.path = path;
        this.secretId = secretId;
        this.secretKey = secretKey;
        this.method = method;
    }

    @Override
    public String call(String action, TreeMap<String, String> param) throws MQClientException, MQServerException {
        try {
            param.put("Action", action);
            param.put("Nonce", Integer.toString(new Random().nextInt(Integer.MAX_VALUE)));
            param.put("SecretId", this.secretId);
            param.put("Timestamp", Long.toString(System.currentTimeMillis() / 1000L));
            this.addSignatureMethod(param);
            String host = this.endpoint.startsWith("https") ? this.endpoint.substring(8) : this.endpoint.substring(7);
            StringBuilder src = new StringBuilder();
            src.append(this.method).append(host).append(this.path).append("?");
            boolean flag = false;
            for (String key : param.keySet()) {
                if (flag) {
                    src.append("&");
                }
                src.append(key.replace("_", ".")).append("=").append(param.get(key));
                flag = true;
            }
            this.addSignature(param, src.toString(), this.secretKey);
            StringBuilder url = new StringBuilder(this.endpoint + this.path);
            StringBuilder req = new StringBuilder();
            flag = false;
            for (String key : param.keySet()) {
                if (flag) {
                    req.append("&");
                }
                req.append(key).append("=").append(URLEncoder.encode(param.get(key), "utf-8"));
                flag = true;
            }
            if (this.method.equals("GET")) {
                url.append("?").append((CharSequence)req);
                req = new StringBuilder();
                if (url.length() > 2048) {
                    throw new MQClientException(220, "URL length is larger than 2K when use GET method");
                }
            }
            if (LogHelper.LOG_REQUEST) {
                this.logger.debug("===> call param:" + param);
            }
            String result = this.doRequest(this.method, url.toString(), req.toString());
            if (LogHelper.LOG_REQUEST) {
                this.logger.debug("===> result:" + result);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("call http request error", (Throwable)e);
            throw new MQClientException("call http request failed.", e);
        }
    }

    protected abstract String doRequest(String var1, String var2, String var3);

    protected abstract void addSignature(TreeMap<String, String> var1, String var2, String var3) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeyException;

    protected abstract void addSignatureMethod(TreeMap<String, String> var1);
}

