/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cmq.client.http;

import com.qcloud.cmq.client.common.CMQTool;
import com.qcloud.cmq.client.common.CloudApiClientConfig;
import com.qcloud.cmq.client.http.AbstractHttpWrapper;
import com.qcloud.cmq.client.http.HttpConnection;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.TreeMap;

public class CloudApiHttpClient
extends AbstractHttpWrapper {
    private CloudApiClientConfig cloudApiClientConfig;
    private HttpConnection httpConnection;

    public CloudApiHttpClient(CloudApiClientConfig cloudApiClientConfig) {
        super(cloudApiClientConfig.getCloudApiAddress(), "/v2/index.php", cloudApiClientConfig.getSecretId(), cloudApiClientConfig.getSecretKey(), "POST");
        this.cloudApiClientConfig = cloudApiClientConfig;
        this.httpConnection = new HttpConnection(cloudApiClientConfig.getRequestTimeoutMS(), false);
    }

    @Override
    protected String doRequest(String method, String url, String requestParam) {
        return this.httpConnection.request(method, url, requestParam);
    }

    @Override
    protected void addSignature(TreeMap<String, String> param, String src, String secretKey) throws NoSuchAlgorithmException, UnsupportedEncodingException, InvalidKeyException {
        param.put("Signature", CMQTool.sign(src, secretKey, this.cloudApiClientConfig.getSignMethod()));
    }

    @Override
    protected void addSignatureMethod(TreeMap<String, String> param) {
        if ("sha1".equals(this.cloudApiClientConfig.getSignMethod())) {
            param.put("SignatureMethod", "sha1");
        } else {
            param.put("SignatureMethod", "sha256");
        }
    }
}

