/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cmq.client.http;

import com.qcloud.cmq.client.common.LogHelper;
import com.qcloud.cmq.client.exception.MQClientException;
import com.qcloud.cmq.client.exception.MQServerException;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;

class HttpConnection {
    private final Logger logger = LogHelper.getLog();
    private int timeout;
    private boolean isKeepAlive;

    HttpConnection() {
        this.timeout = 10000;
        this.isKeepAlive = true;
    }

    HttpConnection(int timeout, boolean isKeepAlive) {
        this.timeout = timeout;
        this.isKeepAlive = isKeepAlive;
    }

    private URLConnection newHttpConnection(String url) throws KeyManagementException, NoSuchAlgorithmException, IOException {
        URLConnection connection;
        HttpConnection.trustAllHttpsCertificates();
        URL realUrl = new URL(url);
        if (url.toLowerCase().startsWith("https")) {
            HttpsURLConnection httpsConn = (HttpsURLConnection)realUrl.openConnection();
            httpsConn.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            connection = httpsConn;
        } else {
            connection = realUrl.openConnection();
        }
        connection.setRequestProperty("Accept", "*/*");
        if (this.isKeepAlive) {
            connection.setRequestProperty("Connection", "Keep-Alive");
        }
        connection.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1;SV1)");
        return connection;
    }

    String request(String method, String url, String req) throws MQClientException, MQServerException {
        StringBuilder result = new StringBuilder();
        BufferedReader in = null;
        try {
            String line;
            URLConnection connection = this.newHttpConnection(url);
            connection.setConnectTimeout(this.timeout);
            if (method.equals("POST")) {
                ((HttpURLConnection)connection).setRequestMethod("POST");
                connection.setDoOutput(true);
                connection.setDoInput(true);
                DataOutputStream out = new DataOutputStream(connection.getOutputStream());
                out.writeBytes(req);
                out.flush();
                out.close();
            }
            connection.connect();
            int status = ((HttpURLConnection)connection).getResponseCode();
            if (status != 200) {
                String errorMsg = String.format("Http request error. return http code:%d", status);
                this.logger.error(errorMsg);
                throw new MQServerException(223, errorMsg);
            }
            in = new BufferedReader(new InputStreamReader(connection.getInputStream(), "utf-8"));
            while ((line = in.readLine()) != null) {
                result.append(line);
            }
        }
        catch (IOException e) {
            this.logger.error("call http request with IOException", (Throwable)e);
            throw new MQServerException(223, "call http request error:" + e.getLocalizedMessage());
        }
        catch (NoSuchAlgorithmException e) {
            this.logger.error("call http request with signature error", (Throwable)e);
            throw new MQClientException("call http request with signature error", e);
        }
        catch (KeyManagementException e) {
            this.logger.error("call http request with signature error", (Throwable)e);
            throw new MQClientException("call http request with signature error", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception exception) {}
        }
        return result.toString();
    }

    private static void trustAllHttpsCertificates() throws NoSuchAlgorithmException, KeyManagementException {
        TrustManager[] trustAllCerts = new TrustManager[1];
        miTM tm = new miTM();
        trustAllCerts[0] = tm;
        SSLContext sc = SSLContext.getInstance("SSL");
        sc.init(null, trustAllCerts, null);
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    static class miTM
    implements TrustManager,
    X509TrustManager {
        miTM() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }
}

