/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cmq.client.netty;

import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.TextFormat;
import com.qcloud.cmq.client.client.CMQClientHandler;
import com.qcloud.cmq.client.common.LogHelper;
import com.qcloud.cmq.client.common.NettyClientConfig;
import com.qcloud.cmq.client.common.RemoteHelper;
import com.qcloud.cmq.client.common.RequestIdHelper;
import com.qcloud.cmq.client.netty.CmqDecoder;
import com.qcloud.cmq.client.netty.CmqEncoder;
import com.qcloud.cmq.client.netty.InvokeCallback;
import com.qcloud.cmq.client.netty.RemoteConnectException;
import com.qcloud.cmq.client.netty.RemoteSendRequestException;
import com.qcloud.cmq.client.netty.RemoteTimeoutException;
import com.qcloud.cmq.client.netty.RemoteTooMuchRequestException;
import com.qcloud.cmq.client.netty.ResponseFuture;
import com.qcloud.cmq.client.netty.SemaphoreReleaseOnlyOnce;
import com.qcloud.cmq.client.protocol.Cmq;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.protobuf.ProtobufDecoder;
import io.netty.handler.codec.protobuf.ProtobufEncoder;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.Semaphore;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;

public class NettyClient {
    private static final Logger logger = LogHelper.getLog();
    private static final long LOCK_TIMEOUT_MILLIS = 3000L;
    private final NettyClientConfig nettyClientConfig;
    private final Bootstrap bootstrap = new Bootstrap();
    private final EventLoopGroup eventLoopGroupWorker;
    private final Lock lockChannelTables = new ReentrantLock();
    private final ConcurrentMap<String, ChannelWrapper> channelTables = new ConcurrentHashMap<String, ChannelWrapper>();
    private final Timer timer = new Timer("ClientHouseKeepingService", true);
    private final CMQClientHandler clientHandler;
    private final ExecutorService executorService;
    private DefaultEventExecutorGroup defaultEventExecutorGroup;
    private final Semaphore semaphoreOneWay;
    private final Semaphore semaphoreAsync;
    private final ConcurrentMap<Long, ResponseFuture> responseTable = new ConcurrentHashMap<Long, ResponseFuture>(256);
    private Cmq.cmq_tcp_auth authData = null;

    public NettyClient(NettyClientConfig nettyClientConfig, CMQClientHandler handler) {
        this.semaphoreOneWay = new Semaphore(nettyClientConfig.getClientOnewaySemaphoreValue(), true);
        this.semaphoreAsync = new Semaphore(nettyClientConfig.getClientAsyncSemaphoreValue(), true);
        this.nettyClientConfig = nettyClientConfig;
        this.clientHandler = handler;
        int publicThreadNums = nettyClientConfig.getClientCallbackExecutorThreads();
        this.executorService = Executors.newFixedThreadPool(publicThreadNums > 0 ? publicThreadNums : 4, new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "NettyClientPublicExecutor_" + this.threadIndex.incrementAndGet());
            }
        });
        this.eventLoopGroupWorker = new NioEventLoopGroup(1, new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "NettyClientPublicExecutor_" + this.threadIndex.incrementAndGet());
            }
        });
    }

    public void setAuthData(Cmq.cmq_tcp_auth authData) {
        this.authData = authData;
    }

    private void processMessageReceived(ChannelHandlerContext ctx, Cmq.CMQProto cmd) throws Exception {
        if (cmd != null) {
            switch (cmd.getCmd()) {
                case 1042: {
                    logger.info("received transaction query");
                    this.processRequestCommand(ctx, cmd);
                    break;
                }
                case 1040: {
                    break;
                }
                case 1041: {
                    break;
                }
                default: {
                    this.processResponseCommand(ctx, cmd);
                }
            }
        }
    }

    private void dealConfirmAck(ChannelHandlerContext ctx, Cmq.CMQProto request) {
        Cmq.cmq_transaction_confirm_reply_item item;
        Cmq.cmq_transaction_confirm_reply reply = request.getTransactionConfirmReply();
        if (reply == null) {
            logger.error("error in proto!");
        }
        if ((item = reply.getItem(0)).getState() != 1 || item.getErrCode() == 3) {
            System.out.println("get error " + item.getErrMsg());
        }
    }

    private void processRequestCommand(final ChannelHandlerContext ctx, final Cmq.CMQProto cmd) {
        block2: {
            Runnable run = new Runnable(){

                @Override
                public void run() {
                    Cmq.CMQProto response = NettyClient.this.clientHandler.processRequest(ctx, cmd);
                    if (response != null) {
                        try {
                            ctx.writeAndFlush((Object)response);
                        }
                        catch (Throwable e) {
                            logger.error("process request over, but response failed", e);
                            logger.error("request:{}", (Object)TextFormat.shortDebugString((Message)cmd));
                            logger.error("response: {}", (Object)TextFormat.shortDebugString((Message)response));
                        }
                    }
                }
            };
            try {
                this.executorService.submit(run);
            }
            catch (RejectedExecutionException e) {
                if (System.currentTimeMillis() % 10000L != 0L) break block2;
                logger.warn(RemoteHelper.parseChannelRemoteAddr(ctx.channel()) + ", too many requests and system thread pool busy, RejectedExecutionException " + this.executorService.toString() + " request code: " + cmd.getCmd());
            }
        }
    }

    private void processResponseCommand(ChannelHandlerContext ctx, Cmq.CMQProto cmd) {
        long requestId = cmd.getSeqno();
        ResponseFuture responseFuture = (ResponseFuture)this.responseTable.get(requestId);
        if (responseFuture != null) {
            if (LogHelper.LOG_REQUEST) {
                logger.debug("processResponseCommand:{}", (Object)TextFormat.shortDebugString((Message)cmd));
            }
            responseFuture.setResponseCommand(cmd);
            responseFuture.release();
            this.responseTable.remove(requestId);
            if (responseFuture.getInvokeCallback() != null) {
                this.executeInvokeCallback(responseFuture);
            } else {
                responseFuture.putResponse(cmd);
            }
        } else {
            logger.warn("receive response, but not matched any request, " + RemoteHelper.parseChannelRemoteAddr(ctx.channel()));
            logger.warn("response:{}", (Object)TextFormat.shortDebugString((Message)cmd));
        }
    }

    private void executeInvokeCallback(final ResponseFuture responseFuture) {
        boolean runInThisThread = false;
        ExecutorService executor = this.executorService;
        if (executor != null) {
            try {
                executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            responseFuture.executeInvokeCallback();
                        }
                        catch (Throwable e) {
                            logger.warn("execute callback in executor exception, and callback throw", e);
                        }
                    }
                });
            }
            catch (Exception e) {
                runInThisThread = true;
                logger.warn("execute callback in executor exception, maybe executor busy", (Throwable)e);
            }
        } else {
            runInThisThread = true;
        }
        if (runInThisThread) {
            try {
                responseFuture.executeInvokeCallback();
            }
            catch (Throwable e) {
                logger.warn("executeInvokeCallback Exception", e);
            }
        }
    }

    private void scanResponseTable() {
        LinkedList<ResponseFuture> rfList = new LinkedList<ResponseFuture>();
        Iterator it = this.responseTable.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry next = it.next();
            ResponseFuture rep = (ResponseFuture)next.getValue();
            if (rep.getBeginTimestamp() + rep.getTimeoutMillis() + 1000L > System.currentTimeMillis()) continue;
            rep.release();
            it.remove();
            rfList.add(rep);
            logger.warn("remove timeout request, " + rep);
        }
        for (ResponseFuture rf : rfList) {
            try {
                this.executeInvokeCallback(rf);
            }
            catch (Throwable e) {
                logger.warn("scanResponseTable, operationComplete Exception", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Cmq.CMQProto invokeSyncImpl(Channel channel, Cmq.CMQProto request, long timeoutMillis) throws InterruptedException, RemoteSendRequestException, RemoteTimeoutException {
        if (LogHelper.LOG_REQUEST) {
            logger.debug("invokeSyncImpl: msg: " + TextFormat.shortDebugString((Message)request) + " timeoutMillis:" + timeoutMillis);
        }
        final long requestId = request.getSeqno();
        try {
            final ResponseFuture responseFuture = new ResponseFuture(timeoutMillis, null, null);
            this.responseTable.put(requestId, responseFuture);
            final SocketAddress address = channel.remoteAddress();
            channel.writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture f) throws Exception {
                    if (f.isSuccess()) {
                        responseFuture.setSendRequestOK(true);
                        return;
                    }
                    responseFuture.setSendRequestOK(false);
                    NettyClient.this.responseTable.remove(requestId);
                    responseFuture.setCause(f.cause());
                    responseFuture.putResponse(null);
                    logger.warn("send a request command to channel <" + address + "> failed.");
                }
            });
            Cmq.CMQProto responseCommand = responseFuture.waitResponse(timeoutMillis);
            if (null == responseCommand) {
                if (responseFuture.isSendRequestOK()) {
                    throw new RemoteTimeoutException(RemoteHelper.parseSocketAddressAddr(address), timeoutMillis, responseFuture.getCause());
                }
                throw new RemoteSendRequestException(RemoteHelper.parseSocketAddressAddr(address), responseFuture.getCause());
            }
            Cmq.CMQProto cMQProto = responseCommand;
            return cMQProto;
        }
        finally {
            this.responseTable.remove(requestId);
        }
    }

    private void invokeAsyncImpl(final Channel channel, Cmq.CMQProto request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemoteTooMuchRequestException, RemoteTimeoutException, RemoteSendRequestException {
        if (LogHelper.LOG_REQUEST) {
            logger.debug("invokeAsyncImpl: msg: " + TextFormat.shortDebugString((Message)request) + " timeoutMillis:" + timeoutMillis);
        }
        final long requestId = request.getSeqno();
        boolean acquired = this.semaphoreAsync.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS);
        if (acquired) {
            SemaphoreReleaseOnlyOnce once = new SemaphoreReleaseOnlyOnce(this.semaphoreAsync);
            final ResponseFuture responseFuture = new ResponseFuture(timeoutMillis, invokeCallback, once);
            this.responseTable.put(requestId, responseFuture);
            try {
                channel.writeAndFlush((Object)request).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture f) throws Exception {
                        if (f.isSuccess()) {
                            responseFuture.setSendRequestOK(true);
                            return;
                        }
                        responseFuture.setSendRequestOK(false);
                        responseFuture.putResponse(null);
                        NettyClient.this.responseTable.remove(requestId);
                        try {
                            NettyClient.this.executeInvokeCallback(responseFuture);
                        }
                        catch (Throwable e) {
                            logger.warn("execute callback in writeAndFlush addListener, and callback throw", e);
                        }
                        finally {
                            responseFuture.release();
                        }
                        logger.warn("send a request command to channel <{}> failed.", (Object)RemoteHelper.parseChannelRemoteAddr(channel));
                    }
                });
            }
            catch (Exception e) {
                responseFuture.release();
                logger.warn("send a request command to channel <" + RemoteHelper.parseChannelRemoteAddr(channel) + "> Exception", (Throwable)e);
                throw new RemoteSendRequestException(RemoteHelper.parseChannelRemoteAddr(channel), e);
            }
        } else {
            if (timeoutMillis <= 0L) {
                throw new RemoteTooMuchRequestException("invokeAsyncImpl invoke too fast");
            }
            String info = String.format("invokeAsyncImpl tryAcquire semaphore timeout, %dms, waiting thread nums: %d semaphoreAsyncValue: %d", timeoutMillis, this.semaphoreAsync.getQueueLength(), this.semaphoreAsync.availablePermits());
            logger.warn(info);
            throw new RemoteTimeoutException(info);
        }
    }

    private void invokeOneWayImpl(final Channel channel, Cmq.CMQProto request, long timeoutMillis) throws InterruptedException, RemoteTooMuchRequestException, RemoteTimeoutException, RemoteSendRequestException {
        boolean acquired;
        if (LogHelper.LOG_REQUEST) {
            logger.debug("invokeOnyWayImpl: msg: " + TextFormat.shortDebugString((Message)request) + " timeoutMillis:" + timeoutMillis);
        }
        if (acquired = this.semaphoreOneWay.tryAcquire(timeoutMillis, TimeUnit.MILLISECONDS)) {
            final SemaphoreReleaseOnlyOnce once = new SemaphoreReleaseOnlyOnce(this.semaphoreOneWay);
            try {
                Cmq.CMQProto newRequest = Cmq.CMQProto.newBuilder(request).build();
                channel.writeAndFlush((Object)newRequest).addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture f) throws Exception {
                        once.release();
                        if (!f.isSuccess()) {
                            logger.warn("send a request command to channel <" + channel.remoteAddress() + "> failed.");
                        }
                    }
                });
            }
            catch (Exception e) {
                once.release();
                logger.warn("write send a request command to channel <" + channel.remoteAddress() + "> failed.");
                throw new RemoteSendRequestException(RemoteHelper.parseChannelRemoteAddr(channel), e);
            }
        } else {
            if (timeoutMillis <= 0L) {
                throw new RemoteTooMuchRequestException("invokeOneWayImpl invoke too fast");
            }
            String info = String.format("invokeOneWayImpl tryAcquire semaphore timeout, %dms, waiting thread nums: %d semaphoreAsyncValue: %d", timeoutMillis, this.semaphoreOneWay.getQueueLength(), this.semaphoreOneWay.availablePermits());
            logger.warn(info);
            throw new RemoteTimeoutException(info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cmq.CMQProto invokeSync(List<String> addressList, Cmq.CMQProto request, long timeoutMillis) throws InterruptedException, RemoteConnectException, RemoteSendRequestException, RemoteTimeoutException {
        Iterator<String> it = addressList.iterator();
        while (it.hasNext()) {
            String address = it.next();
            try {
                Channel channel;
                ChannelWrapper cw = this.getAndCreateChannel(address);
                if (cw == null) {
                    throw new RemoteConnectException(address);
                }
                if (!cw.isLogin()) {
                    NettyClient nettyClient = this;
                    synchronized (nettyClient) {
                        if (!cw.isLogin()) {
                            this.authChannel(cw, timeoutMillis);
                        }
                    }
                }
                if ((channel = cw.getChannel()) != null && channel.isActive()) {
                    try {
                        return this.invokeSyncImpl(channel, request, timeoutMillis);
                    }
                    catch (RemoteSendRequestException e) {
                        logger.warn("invokeSync: send request exception, so close the channel[{}]", (Object)address);
                        this.closeChannel(address, channel);
                        throw e;
                    }
                    catch (RemoteTimeoutException e) {
                        if (this.nettyClientConfig.isClientCloseSocketIfTimeout()) {
                            this.closeChannel(address, channel);
                            logger.warn("invokeSync: close socket because of timeout, {}ms, {}", (Object)timeoutMillis, (Object)address);
                        }
                        logger.warn("invokeSync: wait response timeout exception, the channel[{}]", (Object)address);
                        throw e;
                    }
                }
                this.closeChannel(address, channel);
                throw new RemoteConnectException(address);
            }
            catch (RemoteConnectException e) {
                if (it.hasNext()) continue;
                throw e;
            }
            catch (RemoteSendRequestException e) {
                if (it.hasNext()) continue;
                throw e;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAsync(List<String> addressList, Cmq.CMQProto request, long timeoutMillis, InvokeCallback invokeCallback) throws InterruptedException, RemoteConnectException, RemoteTooMuchRequestException, RemoteTimeoutException, RemoteSendRequestException {
        Iterator<String> it = addressList.iterator();
        while (it.hasNext()) {
            String address = it.next();
            try {
                Channel channel;
                ChannelWrapper cw = this.getAndCreateChannel(address);
                if (cw == null) {
                    throw new RemoteConnectException(address);
                }
                if (!cw.isLogin()) {
                    NettyClient nettyClient = this;
                    synchronized (nettyClient) {
                        if (!cw.isLogin()) {
                            this.authChannel(cw, timeoutMillis);
                        }
                    }
                }
                if ((channel = cw.getChannel()) != null && channel.isActive()) {
                    try {
                        this.invokeAsyncImpl(channel, request, timeoutMillis, invokeCallback);
                        return;
                    }
                    catch (RemoteSendRequestException e) {
                        logger.warn("invokeAsync: send request exception, so close the channel[{}]", (Object)address);
                        this.closeChannel(address, channel);
                        throw e;
                    }
                }
                this.closeChannel(address, channel);
                throw new RemoteConnectException(address);
            }
            catch (RemoteConnectException e) {
                if (it.hasNext()) continue;
                throw e;
            }
            catch (RemoteSendRequestException e) {
                if (it.hasNext()) continue;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeOneWay(List<String> addressList, Cmq.CMQProto request, long timeoutMillis) throws InterruptedException, RemoteConnectException, RemoteTooMuchRequestException, RemoteTimeoutException, RemoteSendRequestException {
        Iterator<String> it = addressList.iterator();
        while (it.hasNext()) {
            String address = it.next();
            try {
                Channel channel;
                ChannelWrapper cw = this.getAndCreateChannel(address);
                if (cw == null) {
                    throw new RemoteConnectException(address);
                }
                if (!cw.isLogin()) {
                    NettyClient nettyClient = this;
                    synchronized (nettyClient) {
                        if (!cw.isLogin()) {
                            this.authChannel(cw, timeoutMillis);
                        }
                    }
                }
                if ((channel = cw.getChannel()) != null && channel.isActive()) {
                    try {
                        this.invokeOneWayImpl(channel, request, timeoutMillis);
                        return;
                    }
                    catch (RemoteSendRequestException e) {
                        logger.warn("invokeOneWay: send request exception, so close the channel[{}]", (Object)address);
                        this.closeChannel(address, channel);
                        throw e;
                    }
                }
                this.closeChannel(address, channel);
                throw new RemoteConnectException(address);
            }
            catch (RemoteConnectException e) {
                if (it.hasNext()) continue;
                throw e;
            }
            catch (RemoteSendRequestException e) {
                if (it.hasNext()) continue;
                throw e;
            }
        }
    }

    public void start() {
        this.defaultEventExecutorGroup = new DefaultEventExecutorGroup(this.nettyClientConfig.getClientWorkerThreads(), new ThreadFactory(){
            private AtomicInteger threadIndex = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "NettyClientWorkerThread_" + this.threadIndex.incrementAndGet());
            }
        });
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.eventLoopGroupWorker)).channel(NioSocketChannel.class)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)false)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.nettyClientConfig.getConnectTimeoutMillis())).option(ChannelOption.SO_SNDBUF, (Object)this.nettyClientConfig.getClientSocketSndBufSize())).option(ChannelOption.SO_RCVBUF, (Object)this.nettyClientConfig.getClientSocketRcvBufSize())).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast((EventExecutorGroup)NettyClient.this.defaultEventExecutorGroup, new ChannelHandler[]{new CmqEncoder(), new ProtobufEncoder(), new CmqDecoder(), new ProtobufDecoder((MessageLite)Cmq.CMQProto.getDefaultInstance()), new IdleStateHandler(0, 0, NettyClient.this.nettyClientConfig.getClientChannelMaxIdleTimeSeconds()), new NettyConnectManageHandler(), new NettyClientHandler()});
            }
        });
        this.timer.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    NettyClient.this.scanResponseTable();
                }
                catch (Exception e) {
                    logger.error("scanResponseTable exception", (Throwable)e);
                }
            }
        }, 3000L, 1000L);
    }

    public void shutdown() {
        try {
            this.timer.cancel();
            for (ChannelWrapper cw : this.channelTables.values()) {
                this.closeChannel(null, cw.getChannel());
            }
            this.channelTables.clear();
            this.eventLoopGroupWorker.shutdownGracefully();
            if (this.defaultEventExecutorGroup != null) {
                this.defaultEventExecutorGroup.shutdownGracefully();
            }
        }
        catch (Exception e) {
            logger.error("NettyClient shutdown exception, ", (Throwable)e);
        }
        if (this.executorService != null) {
            try {
                this.executorService.shutdown();
            }
            catch (Exception e) {
                logger.error("NettyRemoteServer shutdown exception, ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeChannel(String address, Channel channel) {
        block13: {
            if (null == channel) {
                return;
            }
            String addressRemote = null == address ? RemoteHelper.parseChannelRemoteAddr(channel) : address;
            try {
                if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        boolean removeItemFromTable = true;
                        ChannelWrapper prevCW = (ChannelWrapper)this.channelTables.get(addressRemote);
                        logger.info("closeChannel: begin close the channel[{}] Found: {}", (Object)addressRemote, (Object)(prevCW != null ? 1 : 0));
                        if (null == prevCW) {
                            logger.info("closeChannel: the channel[{}] has been removed from the channel table before", (Object)addressRemote);
                            removeItemFromTable = false;
                        } else if (prevCW.getChannel() != channel) {
                            logger.info("closeChannel: the channel[{}] has been closed before, and has been created again, nothing to do.", (Object)addressRemote);
                            removeItemFromTable = false;
                        }
                        if (removeItemFromTable) {
                            this.channelTables.remove(addressRemote);
                            logger.info("closeChannel: the channel[{}] was removed from channel table", (Object)addressRemote);
                        }
                        RemoteHelper.closeChannel(channel);
                        break block13;
                    }
                    catch (Exception e) {
                        logger.error("closeChannel: close the channel exception", (Throwable)e);
                        break block13;
                    }
                    finally {
                        this.lockChannelTables.unlock();
                    }
                }
                logger.warn("closeChannel: try to lock channel table, but timeout, {}ms", (Object)3000L);
            }
            catch (InterruptedException e) {
                logger.error("closeChannel exception", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeChannel(Channel channel) {
        block10: {
            if (null == channel) {
                return;
            }
            try {
                if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
                    try {
                        for (Map.Entry entry : this.channelTables.entrySet()) {
                            ChannelWrapper value = (ChannelWrapper)entry.getValue();
                            if (value.getChannel() == null || value.getChannel() != channel) continue;
                            this.channelTables.remove(entry.getKey());
                            logger.info("closeChannel: the channel[{}] was removed from channel table", entry.getKey());
                            RemoteHelper.closeChannel(channel);
                            break block10;
                        }
                        break block10;
                    }
                    catch (Exception e) {
                        logger.error("closeChannel: close the channel exception", (Throwable)e);
                        break block10;
                    }
                    finally {
                        this.lockChannelTables.unlock();
                    }
                }
                logger.warn("closeChannel: try to lock channel table, but timeout, {}ms", (Object)3000L);
            }
            catch (InterruptedException e) {
                logger.error("closeChannel exception", (Throwable)e);
            }
        }
    }

    private ChannelWrapper getAndCreateChannel(String address) throws InterruptedException {
        ChannelWrapper cw = (ChannelWrapper)this.channelTables.get(address);
        if (cw != null && cw.isOK()) {
            return cw;
        }
        return this.createChannel(address);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private ChannelWrapper createChannel(String address) throws InterruptedException {
        cw = (ChannelWrapper)this.channelTables.get(address);
        if (cw != null && cw.isOK()) {
            return cw;
        }
        if (this.lockChannelTables.tryLock(3000L, TimeUnit.MILLISECONDS)) {
            try {
                cw = (ChannelWrapper)this.channelTables.get(address);
                if (cw != null) {
                    if (cw.isOK()) {
                        var4_3 = cw;
                        return var4_3;
                    }
                    if (!cw.getChannelFuture().isDone()) {
                        createNewConnection = false;
                    } else {
                        this.channelTables.remove(address);
                        createNewConnection = true;
                    }
                } else {
                    createNewConnection = true;
                }
                if (!createNewConnection) ** GOTO lbl33
                channelFuture = this.bootstrap.connect(RemoteHelper.string2SocketAddress(address));
                NettyClient.logger.info("createChannel: begin to connect remote host[{}] asynchronously", (Object)address);
                cw = new ChannelWrapper(channelFuture);
                this.channelTables.put(address, cw);
            }
            catch (Exception e) {
                NettyClient.logger.error("createChannel: create channel exception", (Throwable)e);
            }
            finally {
                this.lockChannelTables.unlock();
            }
        } else {
            NettyClient.logger.warn("createChannel: try to lock channel table, but timeout, {}ms", (Object)3000L);
        }
lbl33:
        // 4 sources

        if (cw != null) {
            channelFuture = cw.getChannelFuture();
            if (channelFuture.awaitUninterruptibly((long)this.nettyClientConfig.getConnectTimeoutMillis())) {
                if (cw.isOK()) {
                    return cw;
                }
                NettyClient.logger.warn("createChannel: connect remote host[" + address + "] failed, " + channelFuture.toString(), channelFuture.cause());
            } else {
                NettyClient.logger.warn("createChannel: connect remote host[{}] timeout {}ms, {}", new Object[]{address, this.nettyClientConfig.getConnectTimeoutMillis(), channelFuture.toString()});
            }
        }
        return null;
    }

    private void authChannel(ChannelWrapper cw, long requestTimeout) throws InterruptedException, RemoteTimeoutException, RemoteSendRequestException {
        if (this.authData == null) {
            throw new RemoteSendRequestException(RemoteHelper.parseSocketAddressAddr(cw.getChannel().remoteAddress()), new Exception("Auth data is null"));
        }
        Cmq.CMQProto request = Cmq.CMQProto.newBuilder().setCmd(1020).setSeqno(RequestIdHelper.getNextSeqNo()).setTcpAuth(this.authData).build();
        Cmq.CMQProto response = this.invokeSyncImpl(cw.getChannel(), request, requestTimeout);
        if (response.getResult() != 0 && response.getResult() != 307) {
            throw new RemoteSendRequestException(RemoteHelper.parseSocketAddressAddr(cw.getChannel().remoteAddress()), new Exception(response.getError()));
        }
        cw.setLogin();
    }

    class NettyConnectManageHandler
    extends ChannelDuplexHandler {
        NettyConnectManageHandler() {
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            String local = localAddress == null ? "UNKNOWN" : RemoteHelper.parseSocketAddressAddr(localAddress);
            String remote = remoteAddress == null ? "UNKNOWN" : RemoteHelper.parseSocketAddressAddr(remoteAddress);
            logger.info("NETTY CLIENT PIPELINE: CONNECT  {} => {}", (Object)local, (Object)remote);
            super.connect(ctx, remoteAddress, localAddress, promise);
        }

        public void disconnect(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            String remoteAddress = RemoteHelper.parseChannelRemoteAddr(ctx.channel());
            logger.info("NETTY CLIENT PIPELINE: DISCONNECT {}", (Object)remoteAddress);
            NettyClient.this.closeChannel(ctx.channel());
            super.disconnect(ctx, promise);
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
            String remoteAddress = RemoteHelper.parseChannelRemoteAddr(ctx.channel());
            logger.info("NETTY CLIENT PIPELINE: CLOSE {}", (Object)remoteAddress);
            NettyClient.this.closeChannel(ctx.channel());
            super.close(ctx, promise);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            IdleStateEvent event;
            if (evt instanceof IdleStateEvent && (event = (IdleStateEvent)evt).state().equals((Object)IdleState.ALL_IDLE)) {
                Cmq.CMQProto.Builder heartBeatBuilder = Cmq.CMQProto.newBuilder();
                heartBeatBuilder.setSeqno(RequestIdHelper.getNextSeqNo());
                heartBeatBuilder.setCmd(1040);
                ctx.channel().writeAndFlush((Object)heartBeatBuilder);
            }
            ctx.fireUserEventTriggered(evt);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            String remoteAddress = RemoteHelper.parseChannelRemoteAddr(ctx.channel());
            logger.warn("NETTY CLIENT PIPELINE: exceptionCaught {}", (Object)remoteAddress);
            logger.warn("NETTY CLIENT PIPELINE: exceptionCaught exception.", cause);
            NettyClient.this.closeChannel(ctx.channel());
        }
    }

    class NettyClientHandler
    extends SimpleChannelInboundHandler<Cmq.CMQProto> {
        NettyClientHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, Cmq.CMQProto msg) throws Exception {
            NettyClient.this.processMessageReceived(ctx, msg);
        }
    }

    static class ChannelWrapper {
        private final ChannelFuture channelFuture;
        private volatile boolean isLogin = false;

        ChannelWrapper(ChannelFuture channelFuture) {
            this.channelFuture = channelFuture;
        }

        boolean isOK() {
            return this.channelFuture.channel() != null && this.channelFuture.channel().isActive();
        }

        private Channel getChannel() {
            return this.channelFuture.channel();
        }

        ChannelFuture getChannelFuture() {
            return this.channelFuture;
        }

        boolean isLogin() {
            return this.isLogin;
        }

        void setLogin() {
            this.isLogin = true;
        }
    }
}

