/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cmq.client.producer;

import com.qcloud.cmq.client.common.ClientConfig;
import com.qcloud.cmq.client.exception.MQClientException;
import com.qcloud.cmq.client.exception.MQServerException;
import com.qcloud.cmq.client.producer.BatchPublishCallback;
import com.qcloud.cmq.client.producer.BatchPublishResult;
import com.qcloud.cmq.client.producer.BatchSendCallback;
import com.qcloud.cmq.client.producer.BatchSendResult;
import com.qcloud.cmq.client.producer.ProducerImpl;
import com.qcloud.cmq.client.producer.PublishCallback;
import com.qcloud.cmq.client.producer.PublishResult;
import com.qcloud.cmq.client.producer.SendCallback;
import com.qcloud.cmq.client.producer.SendResult;
import java.util.List;

public class Producer
extends ClientConfig {
    protected final ProducerImpl producer = new ProducerImpl(this);

    public void start() throws MQClientException {
        this.producer.start();
    }

    public SendResult send(String queue, String msgBody) throws MQClientException, MQServerException {
        return this.send(queue, msgBody, -1);
    }

    protected SendResult sendTransactionMsg(String queue, String msgBody, int firstQueryInterval) throws MQClientException, MQServerException {
        return this.producer.sendTransactionMsg(queue, msgBody, -1, this.getRequestTimeoutMS(), firstQueryInterval);
    }

    public SendResult send(String queue, String msgBody, int delaySeconds) throws MQClientException, MQServerException {
        return this.producer.send(queue, msgBody, delaySeconds, this.getRequestTimeoutMS());
    }

    public BatchSendResult batchSend(String queue, List<String> msgList) throws MQClientException, MQServerException {
        return this.batchSend(queue, msgList, -1);
    }

    public BatchSendResult batchSend(String queue, List<String> msgList, int delaySeconds) throws MQClientException, MQServerException {
        return this.producer.batchSend(queue, msgList, delaySeconds, this.getRequestTimeoutMS());
    }

    protected BatchSendResult batchSendTransactionMsg(String queue, List<String> msgList, int firstQueryInterval) throws MQClientException, MQServerException {
        return this.producer.batchSendTransactionMsg(queue, msgList, -1, this.getRequestTimeoutMS(), firstQueryInterval);
    }

    public void send(String queue, String msgBody, SendCallback callback) throws MQClientException, MQServerException {
        this.send(queue, msgBody, -1, callback);
    }

    public void send(String queue, String msgBody, int delaySeconds, SendCallback callback) throws MQClientException, MQServerException {
        this.producer.send(queue, msgBody, delaySeconds, callback, this.getRequestTimeoutMS());
    }

    public void batchSend(String queue, List<String> msgList, BatchSendCallback callback) throws MQClientException, MQServerException {
        this.batchSend(queue, msgList, -1, callback);
    }

    public void batchSend(String queue, List<String> msgList, int delaySeconds, BatchSendCallback callback) throws MQClientException, MQServerException {
        this.producer.batchSend(queue, msgList, delaySeconds, callback, this.getRequestTimeoutMS());
    }

    public PublishResult publish(String topic, String msgBody, String routeKey) throws MQClientException, MQServerException {
        return this.producer.publish(topic, msgBody, routeKey, (long)this.getRequestTimeoutMS());
    }

    public PublishResult publish(String topic, String msgBody) throws MQClientException, MQServerException {
        return this.producer.publish(topic, msgBody, this.getRequestTimeoutMS());
    }

    public PublishResult publish(String topic, String msgBody, List<String> tagList) throws MQClientException, MQServerException {
        return this.producer.publish(topic, msgBody, tagList, (long)this.getRequestTimeoutMS());
    }

    public BatchPublishResult batchPublish(String topic, List<String> msgList, String routeKey) throws MQClientException, MQServerException {
        return this.producer.batchPublish(topic, msgList, routeKey, (long)this.getRequestTimeoutMS());
    }

    public BatchPublishResult batchPublish(String topic, List<String> msgList, List<String> tagList) throws MQClientException, MQServerException {
        return this.producer.batchPublish(topic, msgList, tagList, (long)this.getRequestTimeoutMS());
    }

    public void publish(String topic, String msgBody, String routeKey, PublishCallback callback) throws MQClientException, MQServerException {
        this.producer.publish(topic, msgBody, routeKey, callback, (long)this.getRequestTimeoutMS());
    }

    public void publish(String topic, String msgBody, List<String> tagList, PublishCallback callback) throws MQClientException, MQServerException {
        this.producer.publish(topic, msgBody, tagList, callback, (long)this.getRequestTimeoutMS());
    }

    public void batchPublish(String topic, List<String> msgList, String routeKey, BatchPublishCallback callback) throws MQClientException, MQServerException {
        this.producer.batchPublish(topic, msgList, routeKey, callback, (long)this.getRequestTimeoutMS());
    }

    public void batchPublish(String topic, List<String> msgList, List<String> tagList, BatchPublishCallback callback) throws MQClientException, MQServerException {
        this.producer.batchPublish(topic, msgList, tagList, callback, (long)this.getRequestTimeoutMS());
    }

    public void shutdown() {
        this.producer.shutdown();
    }
}

