/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cmq.client.producer;

import com.qcloud.cmq.client.common.LogHelper;
import com.qcloud.cmq.client.common.TransactionStatus;
import com.qcloud.cmq.client.exception.MQClientException;
import com.qcloud.cmq.client.exception.MQServerException;
import com.qcloud.cmq.client.producer.BatchSendResult;
import com.qcloud.cmq.client.producer.Producer;
import com.qcloud.cmq.client.producer.SendResult;
import com.qcloud.cmq.client.producer.TransactionBatchSendResult;
import com.qcloud.cmq.client.producer.TransactionExecutor;
import com.qcloud.cmq.client.producer.TransactionSendResult;
import com.qcloud.cmq.client.producer.TransactionStatusChecker;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;

public class TransactionProducer
extends Producer {
    private static final Logger logger = LogHelper.getLog();
    private int firstCheckInterval = 5000;
    private static ConcurrentHashMap<String, TransactionStatusChecker> queueChecker = new ConcurrentHashMap();

    public static TransactionStatusChecker getChecker(String queueName) {
        return queueChecker.get(queueName);
    }

    public static void setChecker(String queueName, TransactionStatusChecker checker) {
        queueChecker.put(queueName, checker);
    }

    public int getFirstCheckInterval() {
        return this.firstCheckInterval;
    }

    public void setFirstCheckInterval(int firstCheckInterval) {
        this.firstCheckInterval = firstCheckInterval;
    }

    public TransactionSendResult sendTransactionMessage(String queue, String message, TransactionExecutor executor, Object arg) throws MQClientException {
        if (null == queue || queue == "") {
            throw new MQClientException("Queue name is empty", null);
        }
        if (null == queueChecker.get(queue)) {
            throw new MQClientException("TransactionStatusChecker is no set", null);
        }
        if (null == executor) {
            throw new MQClientException("TransactionExecutor is no set", null);
        }
        SendResult result = null;
        try {
            result = this.sendTransactionMsg(queue, message, this.getFirstCheckInterval());
        }
        catch (Exception e) {
            throw new MQClientException("Send message error", e);
        }
        if (result.getReturnCode() != 0) {
            return new TransactionSendResult(result.getReturnCode(), result.getMsgId(), result.getRequestId(), result.getErrorMsg(), null);
        }
        TransactionStatus transactionStatus = executor.execute(message, arg);
        if (null == transactionStatus) {
            transactionStatus = TransactionStatus.UN_KNOW;
        }
        if (transactionStatus != TransactionStatus.SUCCESS) {
            logger.info("local executor return [{}]", (Object)transactionStatus);
            logger.info(message);
        }
        try {
            this.sendSecondaryConfirmation(transactionStatus, queue, result);
        }
        catch (MQServerException e) {
            logger.warn("transaction executor execute " + (Object)((Object)transactionStatus) + ", send confirm failed!", (Throwable)e);
        }
        return new TransactionSendResult(result.getReturnCode(), result.getMsgId(), result.getRequestId(), result.getErrorMsg(), transactionStatus);
    }

    public TransactionBatchSendResult batchSendTransactionMessages(String queue, List<String> msgList, List<TransactionExecutor> executorList, List<Object> argList) throws MQClientException {
        if (null == queue || queue == "") {
            throw new MQClientException("Queue name is empty", null);
        }
        if (null == queueChecker.get(queue)) {
            throw new MQClientException("TransactionStatusChecker is no set", null);
        }
        if (null == executorList || executorList.contains(null)) {
            throw new MQClientException("No executorList is set, or executorList contains null", null);
        }
        if (msgList.size() != executorList.size()) {
            throw new MQClientException("The number of message and executor does not match", null);
        }
        BatchSendResult sendResult = null;
        try {
            sendResult = this.batchSendTransactionMsg(queue, msgList, this.getFirstCheckInterval());
        }
        catch (MQServerException e) {
            throw new MQClientException("Batch send message error", e);
        }
        if (sendResult.getReturnCode() != 0) {
            return new TransactionBatchSendResult(sendResult.getReturnCode(), sendResult.getRequestId(), sendResult.getErrorMessage(), null, null);
        }
        ArrayList<TransactionStatus> transactionStatusList = new ArrayList<TransactionStatus>();
        for (int i = 0; i < msgList.size(); ++i) {
            TransactionStatus status = executorList.get(i).execute(msgList.get(i), argList.get(i));
            if (null == status) {
                status = TransactionStatus.UN_KNOW;
            }
            if (status != TransactionStatus.SUCCESS) {
                logger.info("local transaction return [{}]", (Object)status);
            }
            transactionStatusList.add(status);
        }
        try {
            this.sendSecondaryConfirmation(transactionStatusList, queue, sendResult);
        }
        catch (MQServerException e) {
            logger.warn("transaction executor execute " + transactionStatusList + ", send confirm failed {}", (Throwable)e);
        }
        return new TransactionBatchSendResult(sendResult.getReturnCode(), sendResult.getRequestId(), sendResult.getErrorMessage(), sendResult.getMsgIdList(), transactionStatusList);
    }

    private void sendSecondaryConfirmation(TransactionStatus transactionStatus, String queueName, SendResult sendResult) throws MQClientException, MQServerException {
        if (null == transactionStatus) {
            throw new MQClientException("transactionStatus is empty", null);
        }
        if (null == queueName || queueName == "") {
            throw new MQClientException("Queue name is empty", null);
        }
        if (null == sendResult) {
            throw new MQClientException("sendResult is empty", null);
        }
        this.producer.sendConfirmMsgImpl(transactionStatus, queueName, sendResult, (long)this.getRequestTimeoutMS());
    }

    private void sendSecondaryConfirmation(List<TransactionStatus> transactionStatus, String queueName, BatchSendResult sendResult) throws MQClientException, MQServerException {
        this.producer.sendConfirmMsgImpl(transactionStatus, queueName, sendResult, (long)this.getRequestTimeoutMS());
    }
}

