package com.tencent.qcloud.image.avif.fresco;

import static com.tencent.qcloud.image.avif.Avif.AVIF_HEADER_SIZE;

import com.facebook.imageformat.ImageFormat;
import com.tencent.qcloud.image.avif.Avif;

/**
 * <p>
 * Created by jordanqin on 2023/3/1 21:13.
 * Copyright 2010-2020 Tencent Cloud. All Rights Reserved.
 */
public class AvifFormatChecker implements ImageFormat.FormatChecker{
    public static final ImageFormat AVIF = new ImageFormat("AVIF", "avif");

    @Override
    public int getHeaderSize() {
        return AVIF_HEADER_SIZE;
    }

    @Override
    public ImageFormat determineFormat(byte[] headerBytes, int headerSize) {
        if (Avif.isAvif(headerBytes)) {
            return AVIF;
        }
        return null;
    }
}
