package com.tencent.qcloud.image.avif.fresco;

import static com.tencent.qcloud.image.avif.Avif.AVIF_HEADER_SIZE;

import com.facebook.imageformat.ImageFormat;
import com.tencent.qcloud.image.avif.Avif;

/**
 * <p>
 * Created by jordanqin on 2023/3/1 21:13.
 * Copyright 2010-2020 Tencent Cloud. All Rights Reserved.
 */
public class AvisFormatChecker implements ImageFormat.FormatChecker{
    public static final ImageFormat AVIS = new ImageFormat("AVIS", "avis");

    @Override
    public int getHeaderSize() {
        return AVIF_HEADER_SIZE;
    }

    @Override
    public ImageFormat determineFormat(byte[] headerBytes, int headerSize) {
        if (Avif.isAvis(headerBytes)) {
            return AVIS;
        }
        return null;
    }
}
