package com.tencent.qcloud.image.avif.fresco;

import android.graphics.Bitmap;

import com.facebook.imagepipeline.animated.base.AnimatedImageFrame;
import com.tencent.libqcloudavif.AvifImage;

/**
 * <p>
 * Created by jordanqin on 2023/3/2 16:43.
 * Copyright 2010-2020 Tencent Cloud. All Rights Reserved.
 */
public class AvisFrame implements AnimatedImageFrame {
    private final AvifImage mAvifImage;

    public AvisFrame(AvifImage avifImage) {
        this.mAvifImage = avifImage;
    }

    @Override
    public void dispose() {
        this.mAvifImage.destroy();
    }

    @Override
    public void renderFrame(int width, int height, Bitmap bitmap) {
        this.mAvifImage.getBitmap(bitmap, true);
    }

    @Override
    public int getDurationMs() {
        return (int) this.mAvifImage.getDuration();
    }

    @Override
    public int getWidth() {
        return this.mAvifImage.getWidth();
    }

    @Override
    public int getHeight() {
        return this.mAvifImage.getHeight();
    }

    @Override
    public int getXOffset() {
        return 0;
    }

    @Override
    public int getYOffset() {
        return 0;
    }
}
