package com.tencent.qcloud.image.avif.fresco;

import com.facebook.imagepipeline.animated.base.AnimatedDrawableFrameInfo;
import com.facebook.imagepipeline.animated.base.AnimatedImage;
import com.tencent.libqcloudavif.AvifDecoder;
import com.tencent.libqcloudavif.AvifImage;
import com.tencent.qcloud.image.avif.Avif;
import com.tencent.qcloud.image.decoder.utils.ResourcesUtil;

import java.io.IOException;
import java.io.InputStream;

/**
 * <p>
 * Created by jordanqin on 2023/3/2 16:43.
 * Copyright 2010-2020 Tencent Cloud. All Rights Reserved.
 */
public class AvisImage implements AnimatedImage {
    private final Object mLock = new Object();

    private final AvifDecoder mAvifDecoder;
    private final long mBytesLength;

    public AvisImage(InputStream inputStream) {
        byte[] buffer = new byte[0];
        try {
            buffer = ResourcesUtil.inputStreamToBytes(inputStream);
        } catch (IOException e) {
            e.printStackTrace();
        }
        mBytesLength = buffer.length;
        mAvifDecoder = Avif.getAvifDecoder(buffer);
    }

    @Override
    public void dispose() {
        synchronized (mLock) {
            mAvifDecoder.reset();
            mAvifDecoder.destroy();
        }
    }

    @Override
    public int getWidth() {
        return mAvifDecoder.getWidth();
    }

    @Override
    public int getHeight() {
        return mAvifDecoder.getHeight();
    }

    @Override
    public int getFrameCount() {
        return mAvifDecoder.getImageCount();
    }

    @Override
    public int getDuration() {
        return (int) mAvifDecoder.getImageDuration();
    }

    @Override
    public int[] getFrameDurations() {
        synchronized (mLock) {
            int[] frameDurations = new int[getFrameCount()];
            for (int i = 0; i < getFrameCount(); i++) {
                frameDurations[i] = (int) mAvifDecoder.getNthImageDuration(i);
            }
            return frameDurations;
        }
    }

    @Override
    public int getLoopCount() {
        return AnimatedImage.LOOP_COUNT_INFINITE;
    }

    @Override
    public AvisFrame getFrame(int frameNumber) {
//        long startTime = System.nanoTime();
        synchronized (mLock) {
            AvifImage avifImage = Avif.animationDecodeFrame(mAvifDecoder, mBytesLength, frameNumber);
//            long duration = TimeUnit.MILLISECONDS.convert(
//                    System.nanoTime() - startTime,
//                    TimeUnit.NANOSECONDS
//            );
//            Log.d("qjd_getFrame", String.valueOf(duration));
            return new AvisFrame(avifImage);
        }
    }

    @Override
    public boolean doesRenderSupportScaling() {
        return false;
    }

    @Override
    public int getSizeInBytes() {
        return 0;
    }

    @Override
    public AnimatedDrawableFrameInfo getFrameInfo(int frameNumber) {
        return new AnimatedDrawableFrameInfo(
                frameNumber,
                0,
                0,
                mAvifDecoder.getWidth(),
                mAvifDecoder.getHeight(),
                AnimatedDrawableFrameInfo.BlendOperation.BLEND_WITH_PREVIOUS,
                AnimatedDrawableFrameInfo.DisposalMethod.DISPOSE_DO_NOT);
    }
}
