package com.tencent.qcloud.image.avif.fresco;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.os.Build;

import com.facebook.common.internal.Preconditions;
import com.facebook.common.references.CloseableReference;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.tencent.libqcloudavif.AvifDecoder;
import com.tencent.qcloud.image.avif.Avif;
import com.tencent.qcloud.image.decoder.fresco.BaseFrescoDecoder;
import com.tencent.qcloud.image.decoder.utils.ResourcesUtil;

import java.io.IOException;
import java.io.InputStream;

/**
 * <p>
 * Created by jordanqin on 2023/2/22 16:33.
 * Copyright 2010-2020 Tencent Cloud. All Rights Reserved.
 */
public class FrescoAvifDecoder extends BaseFrescoDecoder {
    @Override
    protected CloseableReference<Bitmap> decodeFromStream(InputStream inputStream) throws IOException {
        Preconditions.checkNotNull(inputStream);
        byte[] buffer = ResourcesUtil.inputStreamToBytes(inputStream);

        final AvifDecoder decoder = Avif.getAvifDecoder(buffer);
        int imageWidth = decoder.getWidth();
        int imageHeight = decoder.getHeight();

        CloseableReference<Bitmap> bitmap =
                Fresco.getImagePipelineFactory().getPlatformBitmapFactory().createBitmapInternal(imageWidth, imageHeight, Bitmap.Config.ARGB_8888);
        bitmap.get().eraseColor(Color.TRANSPARENT);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB_MR1) {
            bitmap.get().setHasAlpha(true);
        }

        Avif.decode(decoder, imageWidth, buffer.length, bitmap.get(), null);
        decoder.destroy();
        return bitmap;
    }
}
